#include "mbed.h"
#include "ADXL362.h"
#include "main.h"
 
// Class
 
ADXL362::ADXL362(PinName mosi, PinName miso, PinName sclk, PinName cbs)
    : SPI_m(mosi, miso, sclk) 
    , CBS_m(cbs) {
    CBS_m=1;
    }
    
// SPI 

void ADXL362::init_spi(){
    // spi 8 bits, mode 0, 1 MHz for adxl362
    SPI_m.format(8,0);
    // 5 MHz, max for acc - works fine
    SPI_m.frequency(5000000);
}



void ADXL362::init_adxl362()
{
    uint8_t reg;
    // reset the adxl362
    wait_ms(200);
    ACC_WriteReg(RESET, 0x52);
    wait_ms(200);

    // set FIFO
    ACC_WriteReg(FIFO_CTL,0x0A);  // stream mode, AH bit

///////////////////////////////////////////////////////////////////////////////////////
    reg = ACC_ReadReg(FILTER_CTL);  
    printf("1 ------------------Start : FILTER_CTL = 0x%X\r\n\n", reg);
    

//    printf("2 ------------------Input : FILTER_CTL = 0x17\r\n");
    wait_ms(25);    

///////////////////////////////////////////////////////////////////////////////////////

    //ACC_WriteReg(FIFO_CTL,0x02);  // stream mode, no AH bit
    //reg = ACC_ReadReg(FIFO_CTL);
    //printf("FIFO_CTL = 0x%X\r\n", reg);

    // Not used but keep in case it is important to set FIFO parameters.
    //ACC_WriteReg(FIFO_SAM,SAMPLE_SET * 3);   // fifo depth
    //reg = ACC_ReadReg(FIFO_SAM);
    //pc.printf("FIFO_SAM = 0x%X\r\n", reg);


    printf("2 ------------------Connect accelerometer");

    while(reg != 0x17)
    {
        printf(" vib while...\n");
        
        // set adxl362 to 4g range, 25Hz
        //ACC_WriteReg(FILTER_CTL,0x51);
        // 2g, 25Hz
        ACC_WriteReg(FILTER_CTL,0x17);
        //reg = ACC_ReadReg(FILTER_CTL);
        //printf("FILTER_CTL = 0x%X\r\n", reg);
        
        reg = ACC_ReadReg(FILTER_CTL);

        if(reg == 0x17)
        {
            printf("  Success!!\n\n");
//            printf("2 ------------------Output : FILTER_CTL = 0x%X\r\n\n\n", reg);
            }
        else
        {
            printf(".");
            }
        wait_ms(500);           
    }
 
    // map adxl362 interrupts
    //ACC_WriteReg(INTMAP1,0x01); //data ready
    ACC_WriteReg(INTMAP1,0x04); //watermark
    //reg = ACC_ReadReg(INTMAP1);
    //pc.printf("INTMAP1 = 0x%X\r\n", reg);

    // set adxl362 to measurement mode, ultralow noise
    ACC_WriteReg(POWER_CTL,0x22);
    //reg = ACC_ReadReg(POWER_CTL);
    //pc.printf("POWER_CTL = 0x%X\r\n", reg);
}

void ADXL362::ACC_GetXYZ16(int16_t* x16, int16_t* y16, int16_t* z16)
{
    int8_t x8=0;
    int8_t y8=0;
    int8_t z8=0;
    
    CBS_m = DOWN;
    SPI_m.write(RD_SPI);
    
    SPI_m.write(0x0E);
    x8 = SPI_m.write(0x00);    
    *x16 = x8 << 0;    
    x8 = SPI_m.write(0x00);        
//    *x16 |= x8 << 8; 
    *x16 = x8 << 8; 
    printf("[X Hex value]\n");
    printf("1. x8  : [%02X]\n", x8);
    printf("2. *x16 : [%04X]\n", *x16);
    
    printf("[X Decimal value]\n");
    printf("1. x8  : [%d]\n", x8);
    printf("2. *x16 : [%d]\n", *x16);

    y8 = SPI_m.write(0x00);    
    *y16 = y8 << 0;    
    y8 = SPI_m.write(0x00);    
//    *y16 |= y8 << 8;
    *y16 = y8 << 8;
    printf("\n[Y Hex value]\n");
    printf("1. y8 : [%02X]\n", y8);
    printf("2. *y16 : [%04X]\n", *y16);

    z8 = SPI_m.write(0x00);
    *z16 = z8 << 0;
    z8 = SPI_m.write(0x00);
//    *z16 |= z8 << 8;
    *z16 = z8 << 8;
    printf("\n[Z Hex value]\n");
    printf("1. z8 : [%02X]\n", z8);
    printf("2. *z16 : [%04X]\n", *z16);
    
    CBS_m = UP; 
}

void ADXL362::ACC_GetXYZ8(int8_t* x8, int8_t* y8, int8_t* z8)
{
    
    CBS_m = DOWN;
    SPI_m.write(RD_SPI);
    //-> 레지스터 주소바꿈
    SPI_m.write(0x08);
    
    //-> 인자에 가속도 값 바로저장
    *x8 = SPI_m.write(0x00);
    *y8 = SPI_m.write(0x00);
    *z8 = SPI_m.write(0x00);
    
    CBS_m = UP; 
}

uint8_t ADXL362::ACC_ReadReg( uint8_t reg )
{
    CBS_m = DOWN;
    SPI_m.write(RD_SPI);
    SPI_m.write(reg);
    uint8_t val = SPI_m.write(0x00);
    CBS_m = UP;
    return (val);
}

void ADXL362::ACC_WriteReg( uint8_t reg, uint8_t cmd )
{
    CBS_m = DOWN;
    SPI_m.write(WR_SPI);
    SPI_m.write(reg);
    SPI_m.write(cmd);
    CBS_m = UP;
}
