/******************************************************************************
* DESCRIPTION:
*   A "Blinky" CMSIS RTOS program which demonstrates another safe way
*   to pass arguments to threads during thread creation.  In this case,
*   a structure is used to pass multiple arguments.
* AUTHOR: Jose M. Gomez
* LAST REVISED: 23/SEP/2014
******************************************************************************/

#include <mbed.h>
#include <cmsis_os.h>
#include <stdint.h>
#include <limits.h>

#define NUM_THREADS 6

DigitalOut red(LED1);
DigitalOut green(LED2);
DigitalOut blue(LED3);

void Timer1_Callback (void const *arg) {
    red = !red;                            // update the counter
}

void Timer2_Callback (void const *arg) {
    blue=!blue;                            // update the counter
}

osTimerDef (timer1, Timer1_Callback);
osTimerDef (timer2, Timer2_Callback);

int main (void) {
    osTimerId id1;
    osTimerId id2;

    green = 0;
    id1 = osTimerCreate (osTimer(timer1), osTimerPeriodic, NULL);
    osTimerStart (id1, 100UL);
    id2 = osTimerCreate (osTimer(timer2), osTimerPeriodic, NULL);
    osTimerStart (id2, 157UL);
    green = 1;
}
