#include "mbed.h"

#include "uLCD_4DGL.h"
#include "PinDetect.h"
#include <mpr121.h>


uLCD_4DGL uLCD(p28, p27, p29); // create a global lcd object

// Create the interrupt receiver object on pin 26
InterruptIn interrupt(p26);

// Setup the i2c bus on pins 28 and 27
I2C i2c(p9, p10);

// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

DigitalOut start (p21);
DigitalOut stop (p22);
InterruptIn songOver (p23);



//PinDetect pb1(p26);

int volatile score = 0;
int volatile meter = 15;
int scrollSpeed = 6;

int volatile rightPressed = 0;
int volatile leftPressed = 0;
int volatile upPressed = 0;
int volatile downPressed = 0;

struct arrow {
    int yPos;
    int alive;
    arrow *next;
};

arrow* leftRoot = NULL;
arrow* rightRoot = NULL;
arrow* upRoot = NULL;
arrow* downRoot = NULL;


enum gameState{
    begin,
    playing,
    over};
    
int volatile state;

enum node{
    up,
    down,
    left,
    right,
    none
};

enum difficultyLevels{
    easy,
    medium,  
    hard
};

int volatile nodeToDelete(none);

int volatile difficulty(easy);

void deleteRoot (arrow* &root, int direction) {
    arrow* temp = root;
    
    switch(direction) {
        case 0:
        uLCD.line(4, root->yPos-scrollSpeed,24, root->yPos-scrollSpeed,0x0000FF); 
        uLCD.line(4, root->yPos-scrollSpeed, 14, root->yPos+10-scrollSpeed, 0x0000FF);
        uLCD.line(4, root->yPos-scrollSpeed, 14, root->yPos-10-scrollSpeed, 0x0000FF);
        break;
        
        case 1:
        uLCD.line(47,root->yPos-scrollSpeed-10,47,root->yPos-scrollSpeed+10,0x0000FF); 
        uLCD.line(47, root->yPos-scrollSpeed-10, 37, root->yPos-scrollSpeed, 0x0000FF);
        uLCD.line(47, root->yPos-scrollSpeed-10, 57, root->yPos-scrollSpeed, 0x0000FF);
        break;
        
        case 2:
        uLCD.line(80,root->yPos-scrollSpeed-10,80,root->yPos-scrollSpeed+10,0x0000FF); 
        uLCD.line(80, root->yPos-scrollSpeed+10, 70, root->yPos-scrollSpeed, 0x0000FF);
        uLCD.line(80, root->yPos-scrollSpeed+10, 90, root->yPos-scrollSpeed, 0x0000FF);
        break;
        
        case 3:
        uLCD.line(104,root->yPos-scrollSpeed,124,root->yPos-scrollSpeed,0x0000FF); 
        uLCD.line(124, root->yPos-scrollSpeed, 114, root->yPos-scrollSpeed+10, 0x0000FF);
        uLCD.line(124, root->yPos-scrollSpeed, 114, root->yPos-scrollSpeed-10, 0x0000FF);
        break;    
    }
    
    root = root->next;
    delete temp;
}

void addToEnd (arrow* &root) {
    arrow * temp = root;
    if (root == NULL)
    {
        root = new arrow;
        root->yPos = 10;
        root->alive = 1;
        root->next = 0;  
    }
    else {
        while (temp->next)
        {
            temp = temp->next;    
        }    
    
        temp->next = new arrow;
        temp = temp->next;
        temp->yPos = 10;
        temp->alive = 1;
        temp->next = 0;  
    }
}

void fallInterrupt() {
    int key_code=0;
    int i=0;
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    
    i=0;
    // puts key number out to LEDs for demo
    for (i=0; i<12; i++) {
        if (((value>>i)&0x01)==1) key_code=i+1;
    }
    
    switch (key_code) {
        case 2:
        upPressed = 1;
        if (upRoot) {
            if (upRoot->yPos > 100 && upRoot->yPos < 120)
            {
                score++;
                meter+=2;           
            }
            if (upRoot->yPos > 95)
            {
                nodeToDelete = up;
            }
        }
        break;
        
        case 5:
        leftPressed = 1;
        if (leftRoot) {
            if (leftRoot->yPos > 100 && leftRoot->yPos < 120)
            {
                score++;
                meter+=2;         
            }
            if (leftRoot->yPos > 95)
            {
                nodeToDelete = left;
            }
        }
        break;
        
        case 6:
            switch (state) {
            case begin:
            state = playing;
            break;
            case playing:
             break;
             case over:
            state = begin;
            break;
            }
        break;
        
        case 7:
        rightPressed = 1;
        if (rightRoot) {
            if (rightRoot->yPos > 100 && rightRoot->yPos < 120)
            {
                score++;
                meter+=2;          
            }
            if (rightRoot->yPos > 95)
            {
                nodeToDelete = right;
            }
        }
        break;
        
        case 10:
        downPressed = 1;
        if (downRoot) {
            if (downRoot->yPos > 100 && downRoot->yPos < 120)
            {
                score++;
                meter+=2;         
            }
            if (downRoot->yPos > 95)
            {
                nodeToDelete = down;
            }
        }
        break;
        
        case 4:
        if (state == begin) {
            difficulty = easy;
        }
        break;
        
        case 8:
        if (state == begin) {
            difficulty = medium;
        }
        break;
        
        case 12:
        if (state == begin) {
            difficulty = hard;
        }
        break;
    }
    
}


void pb1_hit_callback() {
       
       switch (state) {
       case begin:
       state = playing;
       break;
       case playing:
       break;
       case over:
       state = begin;
       break;
       }
}

void drawLeftArrow (int y) {
    
    uLCD.line(4,y-scrollSpeed,24,y-scrollSpeed,0x0000FF); 
    uLCD.line(4, y-scrollSpeed, 14, y-scrollSpeed+10, 0x0000FF);
    uLCD.line(4, y-scrollSpeed, 14, y-scrollSpeed-10, 0x0000FF);
    
    
    uLCD.line(4,y,24,y,0x000000); 
    uLCD.line(4, y, 14, y+10, 0x000000);
    uLCD.line(4, y, 14, y-10, 0x000000);
}

void drawUpArrow (int y) {
    uLCD.line(47,y-scrollSpeed-10,47,y-scrollSpeed+10,0x0000FF); 
    uLCD.line(47, y-scrollSpeed-10, 37, y-scrollSpeed, 0x0000FF);
    uLCD.line(47, y-scrollSpeed-10, 57, y-scrollSpeed, 0x0000FF);
    
    uLCD.line(47,y-10,47,y+10,0x000000); 
    uLCD.line(47, y-10, 37, y, 0x000000);
    uLCD.line(47, y-10, 57, y, 0x000000);
}

void drawDownArrow (int y) {
    uLCD.line(80,y-scrollSpeed-10,80,y-scrollSpeed+10,0x0000FF); 
    uLCD.line(80, y-scrollSpeed+10, 70, y-scrollSpeed, 0x0000FF);
    uLCD.line(80, y-scrollSpeed+10, 90, y-scrollSpeed, 0x0000FF);
    
    uLCD.line(80,y-10,80,y+10,0x000000); 
    uLCD.line(80, y+10, 70, y, 0x000000);
    uLCD.line(80, y+10, 90, y, 0x000000);
}

void drawRightArrow (int y) {
    uLCD.line(104,y-scrollSpeed,124,y-scrollSpeed,0x0000FF); 
    uLCD.line(124, y-scrollSpeed, 114, y-scrollSpeed+10, 0x0000FF);
    uLCD.line(124, y-scrollSpeed, 114, y-scrollSpeed-10, 0x0000FF);
    
    uLCD.line(104,y,124,y,0x000000); 
    uLCD.line(124, y, 114, y+10, 0x000000);
    uLCD.line(124, y, 114, y-10, 0x000000);
}

void songOverInterrupt () {
    state = over;    
}

int main() {
    
    state = begin;
    srand(time(NULL));
    
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    
    songOver.rise(&songOverInterrupt);

    uLCD.baudrate(3000000);
    uLCD.cls();
    
    uLCD.filled_rectangle(0,0,128,128,0x0000FF);
    
    int go = 1;
    int scoreWrite = 1;
    int ready;
    int leftCounter;
    int rightCounter;
    int upCounter;
    int downCounter;
    
    int deleted = 0;
    
    int drawArrow = 1;
    
    
    Timer t;
    float time = 0.0;
    
    arrow * temp;
    
    while(go) {
        t.reset();
        t.start();
        drawArrow = 1;
        
        switch (state) {
        case begin:
        uLCD.locate(5,2);
        uLCD.color(WHITE);
        uLCD.textbackground_color(BLUE);
        uLCD.text_mode(OPAQUE);
        uLCD.set_font(FONT_7X8);
        uLCD.printf("MBED DDR");
        
        uLCD.locate(0,4);
        uLCD.printf("Difficulty: 3,7,11");
        
        uLCD.locate(1,10);
        uLCD.printf("Press 5 to Start");
        
        switch (difficulty) {
        case easy:
            leftCounter = rand()%200 + 75;
            rightCounter = rand()%200 + 75;
            upCounter = rand()%200 + 75;
            downCounter = rand()%200 + 75;
            scrollSpeed = 2;
            
            uLCD.locate(7,6);
            uLCD.printf("Easy  ");
        break;
        
        case medium:
            leftCounter = rand()%150 + 50;
            rightCounter = rand()%150 + 50;
            upCounter = rand()%150 + 50;
            downCounter = rand()%150 + 50;
            scrollSpeed = 4;
            
            uLCD.locate(7,6);
            uLCD.printf("Medium");
        break;
        
        case hard:
            leftCounter = rand()%100 + 25;
            rightCounter = rand()%100 + 25;
            upCounter = rand()%100 + 25;
            downCounter = rand()%100 + 25;
            scrollSpeed = 6;
            
            uLCD.locate(7,6);
            uLCD.printf("Hard  ");
        break; 
        }
    
        ready = 0;
        
        
        
        break;
        
        case playing:
        
        if (!ready)
        {
            uLCD.cls();
            
            uLCD.filled_rectangle(0,0,128,128,0x0000FF);

            uLCD.filled_rectangle(0,100,3,120,0xFFFFFF);
            uLCD.filled_rectangle(25,100,36,120,0xFFFFFF);
            uLCD.filled_rectangle(58,100,69,120,0xFFFFFF);
            uLCD.filled_rectangle(91,100,103,120,0xFFFFFF);
            uLCD.filled_rectangle(125,100,128,120,0xFFFFFF);
            
            ready = 1;
            start = 1;
            stop = 0;
        }
        
        if (leftCounter <= 0){
            addToEnd(leftRoot);
            
            switch (difficulty) {
                case easy:
                leftCounter = rand()%200 + 75;
                break;
                
                case medium:
                leftCounter = rand()%150 + 50;
                break;
                
                case hard:
                leftCounter = rand()%100 + 25;
                break;    
            }
            drawArrow = 0;
        }
            
        leftCounter-=scrollSpeed;
        
        temp = leftRoot;
        while (temp != NULL)
        {
            drawLeftArrow(temp->yPos);
            (temp->yPos)+=scrollSpeed;
            temp = temp->next;
        }
        
        if (leftRoot != NULL) {
            if (leftRoot->yPos >= 120 || nodeToDelete == left) {
                meter--;
                deleteRoot(leftRoot, 0);
                deleted = 1;    
            }
        }
        
        
        
        
        
        if (downCounter <= 0 && drawArrow){
            addToEnd(downRoot);
            switch (difficulty) {
                case easy:
                downCounter = rand()%200 + 75;
                break;
                
                case medium:
                downCounter = rand()%150 + 50;
                break;
                
                case hard:
                downCounter = rand()%100 + 25;
                break;    
            }
            drawArrow = 0;
        }
            
        downCounter-=scrollSpeed;
        
        temp = downRoot;
        while (temp != NULL)
        {
            drawDownArrow(temp->yPos);
            (temp->yPos)+=scrollSpeed;
            temp = temp->next;
        }
        
        if (downRoot != NULL) {
            if (downRoot->yPos >= 120 || nodeToDelete == down) {
                meter--;
                deleteRoot(downRoot, 2);  
                deleted = 1;   
            }
        }
        
        
        
        
        
        if (rightCounter <= 0 && drawArrow){
            addToEnd(rightRoot);
            switch (difficulty) {
                case easy:
                rightCounter = rand()%200 + 75;
                break;
                
                case medium:
                rightCounter = rand()%150 + 50;
                break;
                
                case hard:
                rightCounter = rand()%100 + 25;
                break;    
            }

            drawArrow = 0;
        }
            
        rightCounter-=scrollSpeed;
        
        temp = rightRoot;
        while (temp != NULL)
        {
            drawRightArrow(temp->yPos);
            (temp->yPos)+=scrollSpeed;
            temp = temp->next;
        }
        
        if (rightRoot != NULL) {
            if (rightRoot->yPos >= 120 || nodeToDelete == right) {
                meter--;
                deleteRoot(rightRoot, 3);   
                deleted = 1;  
            }
        }
        
        
        
        
        
        if (upCounter <= 0 && drawArrow){
            addToEnd(upRoot);
            switch (difficulty) {
                case easy:
                upCounter = rand()%200 + 75;
                break;
                
                case medium:
                upCounter = rand()%150 + 50;
                break;
                
                case hard:
                upCounter = rand()%100 + 25;
                break;    
            }

            drawArrow = 0;
        }
            
        upCounter-=scrollSpeed;
        
        temp = upRoot;
        while (temp != NULL)
        {
            drawUpArrow(temp->yPos);
            (temp->yPos)+=scrollSpeed;
            temp = temp->next;
        }
        
        if (upRoot != NULL) {
            if (upRoot->yPos >= 120 || nodeToDelete == up) {
                meter--;
                deleteRoot(upRoot, 1);    
                deleted = 1; 
            }
        }
        
        break;
        
        case over:
        if (ready)
        {
            stop = 1;
            start = 0;
            while (leftRoot) {
                deleteRoot(leftRoot,0);    
            }
            
            while (upRoot) {
                deleteRoot(upRoot,1);    
            }
            
            while (downRoot) {
                deleteRoot(downRoot,2);    
            }
            
            while (rightRoot) {
                deleteRoot(rightRoot,3);    
            }
            
            uLCD.locate(5,8);
            uLCD.color(WHITE);
            uLCD.textbackground_color(BLUE);
            uLCD.text_mode(OPAQUE);
            uLCD.set_font(FONT_7X8);
            uLCD.printf("Game Over");
        
            uLCD.locate(14,0);
            uLCD.printf("%04d", score);
            ready = 0;
            score = 0;
            meter = 15;
        }
        break;
        }
        t.stop();
        time = .1-t.read();
        if (time < 0) time = 0;
        uLCD.locate(0,0);
        uLCD.printf("%04d", score);
        
        
        if (meter > 15) meter = 15;
        uLCD.locate(14,0);
        uLCD.printf("%4d", meter);
        
        if (meter < 0) state = over;
        
        if (deleted)
        {
            nodeToDelete = none;
            deleted = 0;
        }
        wait(time);
    }
}
