#include "mbed.h"
#include "rtos.h"

#include "SDFileSystem.h"
#include "wave_player.h"
#include "uLCD_4DGL.h"
#include "PinDetect.h"


uLCD_4DGL uLCD(p28, p27, p29); // create a global lcd object

SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card

AnalogOut DACout(p18);

wave_player waver(&DACout);

PinDetect pb1(p26);

int score = 0;
int wallSpeed = 1;
int wall1x1 = 80;
int wall1x2 = 100;
int wall1y1 = 0;
int wall1y2 = 40;
int wall2x1 = 80;
int wall2x2 = 100;
int wall2y1 = 88;
int wall2y2 = 128;

int ballxpos = 30;
int ballypos = 64;
int ballrad = 3;

int volatile ballVel = 1;

enum gameState{
    begin,
    playing,
    over};
    
int volatile state;

FILE *wave_file;

void playPointSound(void const *argument) {
    while(1) {
    Thread::signal_wait(0x1);
    //open wav file
    //FILE *wave_file;
    //wave_file=fopen("/sd/sfx_point.wav","r");
    
    //play wav file
    waver.play(wave_file);
    
    //close wav file
    fclose(wave_file);
    }
}

void playDeadSound(void const *argument) {
    while(1) {
    Thread::signal_wait(0x1);
    //open wav file
    FILE *wave_file;
    wave_file=fopen("/sd/sfx_die.wav","r");
    
    //play wav file
    waver.play(wave_file);
    
    //close wav file
    fclose(wave_file);
    }
}


void pb1_hit_callback() {
       
       switch (state) {
       case begin:
       state = playing;
       break;
       case playing:
       ballVel = ballVel-10;
       break;
       case over:
       state = begin;
       break;
       }
}

int main() {
    
    state = begin;
    Thread thread(playPointSound);
    Thread thread2(playDeadSound);
    
    wave_file=fopen("/sd/sfx_point.wav","r");
    
    int ready = 0;
    
    pb1.mode(PullUp);
    wait(.01);
    pb1.attach_deasserted(&pb1_hit_callback);
    pb1.setSampleFrequency();

    uLCD.baudrate(3000000);
    uLCD.cls();
    
    uLCD.filled_rectangle(0,0,128,128,0x0000FF);
    uLCD.filled_circle(ballxpos, ballypos, ballrad, 0xFF00FF);
    uLCD.filled_rectangle(wall1x1, wall1y1, wall1x2, wall1y2, 0x00FF00);
    uLCD.filled_rectangle(wall2x1, wall2y1, wall2x2, wall2y2, 0x00FF00);
    uLCD.locate(14,0);
    uLCD.printf("%04d", score);
    
    int go = 1;
    int scoreWrite = 1;
    while(go) {
        
        switch (state) {
        case begin:
        
        uLCD.locate(4,2);
        uLCD.color(WHITE);
        uLCD.textbackground_color(BLUE);
        uLCD.text_mode(OPAQUE);
        uLCD.set_font(FONT_7X8);
        uLCD.printf("Flappy mbed");
        
        uLCD.locate(1,10);
        uLCD.printf("Press PB to Start");
        ready = 0;
        
        
        break;
        
        case playing:
        
        if (!ready)
        {
            uLCD.cls();
            
            wall1x1 = 80;
            wall1x2 = 100;
            wall1y1 = 0;
            wall1y2 = 40;
            wall2x1 = 80;
            wall2x2 = 100;
            wall2y1 = 88;
            wall2y2 = 128;

            ballxpos = 30;
            ballypos = 64;
            ballrad = 3;
    
            uLCD.filled_rectangle(0,0,128,128,0x0000FF);
            uLCD.filled_circle(ballxpos, ballypos, ballrad, 0xFF00FF);
            uLCD.filled_rectangle(wall1x1, wall1y1, wall1x2, wall1y2, 0x00FF00);
            uLCD.filled_rectangle(wall2x1, wall2y1, wall2x2, wall2y2, 0x00FF00);
            ready = 1;
        }
        
        wall1x1--;
        wall2x1--;
        wall1x2--;
        wall2x2--;
        
        if (wall1x2 < -1)
        {
            wall1x2 = 148;
            wall1x1 = 128;
            wall2x2 = 148;
            wall2x1 = 128;
        
            wall1y2 = rand() % (73) + 8;
            wall2y1 = wall1y2 + 48;
            scoreWrite = 1;
        }
        
        if(wall1x2 < 95 && scoreWrite == 1)
        {
            uLCD.locate(14,0);
            uLCD.printf("%04d", score);
            scoreWrite = 0;
        }
        
        
        uLCD.filled_rectangle(wall1x1, wall1y1, wall1x2, wall1y2, 0x00FF00);
        uLCD.filled_rectangle(wall2x1, wall2y1, wall2x2, wall2y2, 0x00FF00);
        uLCD.line(wall1x2+1,wall1y1,wall1x2+1,wall1y2+1,0x0000FF); 
        uLCD.line(wall1x2+1,wall2y1,wall1x2+1,wall2y2+1,0x0000FF);
        
        if (ballxpos == (wall1x1 + 10))
        {
            thread.signal_set(0x1);
            score++;
            wave_file=fopen("/sd/sfx_point.wav","r");
            uLCD.locate(14,0);
            uLCD.printf("%04d", score);   
        } 
        
        uLCD.filled_circle(ballxpos, ballypos, ballrad, 0x0000FF);
        if (ballVel < 2)
            ballVel++;
            
        ballypos = ballypos + ballVel;
        uLCD.filled_circle(ballxpos, ballypos, ballrad, 0xFF00FF);
        
        if (ballypos - 2 < wall1y2) {
            if (ballxpos+2 > wall1x1 && ballxpos-2 < wall1x2) {
                state = over;
            }
        }
        else if (ballypos + 2 > wall2y1) {
            if (ballxpos+2 > wall2x1 && ballxpos-2 < wall2x2) {
                state = over;    
            }
        }
        
        if (ballypos > 125) {
            state = over;
        }
        
        break;
        
        case over:
        //open wav file
        if (ready)
        {
            Thread::wait(300);
            fclose(wave_file);
            FILE *wave_file2;
            wave_file2=fopen("/sd/sfx_hit.wav","r");
    
            //play wav file
            waver.play(wave_file2);
    
            //close wav file
            fclose(wave_file2);
            
            if (ballypos < 125)
            {
               //wave_file2=fopen("/sd/sfx_die.wav","r");
    
                //play wav file
                //waver.play(wave_file2);
    
                //close wav file
                //fclose(wave_file2);
                
                thread2.signal_set(0x1);
                
                for (int i = ballypos; i < 125; i++)
                {
                     uLCD.filled_circle(ballxpos, i, ballrad, 0x0000FF);
                     uLCD.filled_circle(ballxpos, i+1, ballrad, 0xFF00FF);   
                }    
            }
        
            uLCD.locate(5,8);
            uLCD.color(WHITE);
            uLCD.textbackground_color(BLUE);
            uLCD.text_mode(OPAQUE);
            uLCD.set_font(FONT_7X8);
            uLCD.printf("Game Over");
        
            uLCD.locate(14,0);
            uLCD.printf("%04d", score);
            ready = 0;
            score = 0;
        }
        break;
        }
    }
}
