#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"

AnalogIn Vin(PTC2);
AnalogOut Vout(PTE30);
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DebouncedIn button1(PTC12);     // Aumento
DebouncedIn button2(PTC13);     // Disminución
DebouncedIn button3(PTC16);     // Cambio de variable
DebouncedIn button4(PTC17);     // Reset

int C1=0x0E;                                                // solo muestra el curzor.
int C2=0x18;                                                // desplaza izquierda.
int C3=0x1A;                                                // desplaza derecha.
int C4=0x0C;                                                // quito cursor bajo.

int i;                                                      // Indice de la variable.
int j;                                                      // Controla cambio de posición.
int kp, ki, kd, sp, cont; 
int Error, Medida, Co, pid, ap, ai, ad, err_v;
// float pidn, err, med, sal;
int pidn, err, med, sal;

int main(){
    lcd.writeCommand(C1);                                   // Escribimos un comando segun el manual del modulo LCD
    lcd.cls();                                               // Borro toda la pantalla
    lcd.locate(0,0);                                         // Localizo donde se escribirá el siguiente comando.    
    lcd.printf("Sp %d",sp);                                  // Escribe Sp (aparecen desde el punto (0,0)
    lcd.locate(8,0);                                         // Localizo donde se escribirá el siguiente comando.
    lcd.printf("Kp %d",kp);                                  // Escribe Kp (aparecen desde el punto (8,0)
    lcd.locate(0,1);
    lcd.printf("Ki %d",ki);
    lcd.locate(8,1);
    lcd.printf("Kd %d",kd);
  
        
    while(1){
           led3 =1;
           if (button3.falling()){
              led3 =!led3;                                // Prendo el LED color rojo cada vez que pulso el boton 3 ya que pasa a valer 0 (encendido).              
               ++j;
                                 }                        // INCREMENTA POSICION DEL MENU CON BOTON 3
           if (j==0){
               lcd.locate(3,0);
               lcd.printf("%d",sp);
               wait(0.2);
                  
               led1 = 1;
               
               if(button1.falling()) { 
               led1 =!led1;                            // Prendo el LED color azul cada vez que pulso el boton 1 ya que pasa a valer 0 (encendido).        
               //++sp;                                 // Incrementa valor al pulsar el botón --> Ahora no lo usamos acá ya que necesitamos incremental.
               
               
               // Ahora comienza el incremental.               
               
                  if (!button1) {  
                  cont=0;
                  wait(0.2);
               
                     while(cont<20){ 
                     cont = cont + 1;   
                     sp=sp+1; 
                     if (sp>1000){                     // Ponemos un tope incremental en 1.000
                     sp=1000;
                                 }       
                     lcd.locate(0,0); 
                     lcd.printf("Sp %d",sp); 
                     
                     wait(0.3); 
                     if(button1){ 
                     break; 
                                }              
                     while(cont>=20 and cont<=40){ 
                     cont=cont+1;   
                     sp=sp+10;
                     if (sp>1000){                     // Ponemos un tope incremental en 10.000
                     sp=1000;
                               }  
                     lcd.locate(0,0); 
                     lcd.printf("Sp %d",sp); 
                                     
                     wait(0.3); 
                     if(button1){ 
                     break; 
                                }
                                
                     while(cont>40){ 
                     cont = cont + 1;   
                     sp=sp+100;
                     if (sp>1000){                     // Ponemos un tope incremental en 10.000
                     sp=1000;
                               }  
                     lcd.locate(0,0); 
                     lcd.printf("Sp %d",sp); 
                     
                     wait(0.3); 
                     if(button1){ 
                     break; 
                                }                                
                            }    
                            }
                            }
                            }
                            
        // Aqui termina el incremental.
                                      }

                                         
                  led2 =1;
                  if (button2.falling()) {  
                  led2 =!led2;                            // Prendo el LED color rojo cada vez que pulso el boton 2 ya que pasa a valer 0 (encendido).       
                  
                  //--sp;                                   // Reduce el valor al pulsar el botón.
                                         } 
                  
                                  
                  // Ahora comienza el decremental.               
               
                  if (!button2) {  
                  cont=0;
                  wait(0.2);
               
                     while(cont<20){ 
                     cont = cont + 1;   
                     sp=sp-1; 
                     
                     if (sp<=0){                         // No permitimos valores negativos, definimos valor mínimo en 0.
                     sp=0;
                              }
                     lcd.locate(3,0);
                     lcd.printf("     ");
                     lcd.locate(0,0);
                     lcd.printf("Sp %d",sp);
                                                                          
                     wait(0.3); 
                     if(button2){ 
                     break; 
                                }              
                      
                     while(cont>=20 and cont<=40){ 
                     cont=cont+1;   
                     sp=sp-10; 
                     if (sp<0){                         // No permitimos valores negativos, definimos valor mínimo en 0.
                     sp=0;
                              }
                     
                     lcd.locate(0,0); 
                     lcd.printf("Sp %d ",sp); 
                     
                                     
                     wait(0.3); 
                     if(button2){ 
                     break; 
                                }
                                
                     while(cont>40){ 
                     cont = cont + 1;   
                     sp=sp-100; 
                     
                     if (sp<0){                         // No permitimos valores negativos, definimos valor mínimo en 0.
                     sp=0;
                              }
                     
                     lcd.locate(0,0); 
                     lcd.printf("Sp %d ",sp); 
                     
                     
                     wait(0.3); 
                     if(button2){ 
                     break; 
                                }                                
                            }    
                            }
                            }
                            }
                            
        // Aqui termina el decremental.
                  
                          
                    }
           if (j==1){
               lcd.locate(11,0);
               lcd.printf("%d",kp);
               wait(0.3);
                  led1 =1;
                  if (button1.falling()) {
                    led1 =!led1;
                    // ++kp;
                                         }

            // Ahora comienza el incremental.               
               
                     if (!button1) {  
                     cont=0;
                     wait(0.2);
               
                     while(cont<20){ 
                     cont = cont + 1;   
                     kp=kp+1; 
                     if (kp>1000){                     // Ponemos un tope incremental en 10.000
                     kp=1000;
                               }       
                     lcd.locate(8,0); 
                     lcd.printf("Kp %d",kp); 
                     
                     wait(0.3); 
                     if(button1){ 
                     break; 
                                }              
                     while(cont>=20){ 
                     cont=cont+1;   
                     kp=kp+10;
                     if (kp>1000){                     // Ponemos un tope incremental en 10.000
                     kp=1000;
                               }  
                     lcd.locate(8,0); 
                     lcd.printf("Kp %d",kp); 
                                     
                     wait(0.3); 
                     if(button1){ 
                     break; 
                                }
                                
                     while(cont>40){ 
                     cont = cont + 1;   
                     kp=kp+100;
                     if (kp>1000){                     // Ponemos un tope incremental en 10.000
                     kp=1000;
                               }  
                     lcd.locate(8,0); 
                     lcd.printf("Kp %d",kp); 
                     
                     wait(0.3); 
                     if(button1){ 
                     break; 
                                }                                
                            }    
                            }
                            }
                            }
                            
        // Aqui termina el incremental.
                                      }

                                         
                  led2 =1;
                  if (button2.falling()) {  
                  led2 =!led2;                            // Prendo el LED color rojo cada vez que pulso el boton 2 ya que pasa a valer 0 (encendido).       
                  
                  //--sp;                                   // Reduce el valor al pulsar el botón.
                                         } 
                  
                                  
                  // Ahora comienza el decremental.               
               
                  if (!button2) {  
                  cont=0;
                  wait(0.2);
               
                     while(cont<20){ 
                     cont = cont + 1;   

                     kp=kp-1; 
                     
                     if (kp<=0){                         // No permitimos valores negativos, definimos valor mínimo en 0.
                     kp=0;
                              }
                     
                     lcd.locate(8,0);
                     lcd.printf("     ");
                     lcd.locate(8,0);
                     lcd.printf("Kp %d",kp);
                                           
                     wait(0.3); 
                     if(button2){ 
                     break; 
                                }              
                      
                     while(cont>=20){ 
                     cont=cont+1;   
                     kp=kp-10; 
                     if (kp<0){                         // No permitimos valores negativos, definimos valor mínimo en 0.
                     kp=0;
                              }

                     lcd.locate(8,0);
                     lcd.printf("     ");
                     lcd.locate(8,0); 
                     lcd.printf("Kp %d ",kp); 
                     
                     wait(0.3); 
                     if(button2){ 
                     break; 
                                }
                                
                     while(cont>40){ 
                     cont = cont + 1;   
                     kp=kp-100; 
                     
                     if (kp<0){                         // No permitimos valores negativos, definimos valor mínimo en 0.
                     kp=0;
                              }
                     lcd.locate(8,0);
                     lcd.printf("     ");
                     lcd.locate(8,0); 
                     lcd.printf("Kp %d ",kp); 
                     
                     
                     wait(0.3); 
                     if(button2){ 
                     break; 
                                }                                
                            }    
                            }
                            }
                            }



           if (j==2){
               lcd.locate(3,1);
               lcd.printf("%d",ki);
               wait(0.3);
                  led1 =1;
                  if (button1.falling()){
                    led1 =!led1;

               //++sp;                                 // Incrementa valor al pulsar el botón --> Ahora no lo usamos acá ya que necesitamos incremental.
               
               
               // Ahora comienza el incremental.               
               
                  if (!button1) {  
                  cont=0;
                  wait(0.2);
               
                     while(cont<20){ 
                     cont = cont + 1;   
                     ki=ki+1; 
                     if (ki>1000){                     // Ponemos un tope incremental en 1.000
                     ki=1000;
                                 }       
                     lcd.locate(0,1); 
                     lcd.printf("Ki %d",ki); 
                     
                     wait(0.3); 
                     if(button1){ 
                     break; 
                                }              
                     while(cont>=20 and cont<=40){ 
                     cont=cont+1;   
                     ki=ki+10;
                     if (ki>1000){                     // Ponemos un tope incremental en 10.000
                     ki=1000;
                               }  
                     lcd.locate(0,1); 
                     lcd.printf("Ki %d",ki); 
                                     
                     wait(0.3); 
                     if(button1){ 
                     break; 
                                }
                                
                     while(cont>40){ 
                     cont = cont + 1;   
                     ki=ki+100;
                     if (ki>1000){                     // Ponemos un tope incremental en 10.000
                     ki=1000;
                               }  
                     lcd.locate(0,1); 
                     lcd.printf("Ki %d",ki); 
                     
                     wait(0.3); 
                     if(button1){ 
                     break; 
                                }                                
                            }    
                            }
                            }
                            }
                            }
        // Aqui termina el incremental.
                                      }

                                         
                  led2 =1;
                  if (button2.falling()) {  
                  led2 =!led2;                            // Prendo el LED color rojo cada vez que pulso el boton 2 ya que pasa a valer 0 (encendido).       
                  
                  //--sp;                                   // Reduce el valor al pulsar el botón.
                                         } 
                  
                                  
                  // Ahora comienza el decremental.               
               
                  if (!button2) {  
                  cont=0;
                  wait(0.2);
               
                     while(cont<20){ 
                     cont = cont + 1;   
                     ki=ki-1; 
                     
                     if (ki<=0){                         // No permitimos valores negativos, definimos valor mínimo en 0.
                     ki=0;
                              }
                     lcd.locate(3,1);
                     lcd.printf("    ");
                     lcd.locate(0,1);
                     lcd.printf("Ki %d",ki);
                                                                          
                     wait(0.3); 
                     if(button2){ 
                     break; 
                                }              
                      
                     while(cont>=20 and cont<=40){ 
                     cont=cont+1;   
                     ki=ki-10; 
                     if (sp<0){                         // No permitimos valores negativos, definimos valor mínimo en 0.
                     ki=0;
                              }
                     
                     lcd.locate(3,1);
                     lcd.printf("    ");
                     lcd.locate(0,0); 
                     lcd.printf("Ki %d ",ki); 
                     
                                     
                     wait(0.3); 
                     if(button2){ 
                     break; 
                                }
                                
                     while(cont>40){ 
                     cont = cont + 1;   
                     ki=ki-100; 
                     
                     if (ki<0){                         // No permitimos valores negativos, definimos valor mínimo en 0.
                     ki=0;
                              }
                     
                     lcd.locate(3,1);
                     lcd.printf("    ");
                     lcd.locate(0,0); 
                     lcd.printf("Ki %d ",ki); 
                     
                     
                     wait(0.3); 
                     if(button2){ 
                     break; 
                                }                                
                            }    
                            }
                            }
                            }
                            
        // Aqui termina el decremental.
           
           if (j==3){
               lcd.locate(11,1);
               lcd.printf("%d",kd);
               wait(0.3);
                  led1 =1;
                  if (button1.falling()){
                  led1 =!led1;
                  
                                 //++sp;                                 // Incrementa valor al pulsar el botón --> Ahora no lo usamos acá ya que necesitamos incremental.
               
               
               // Ahora comienza el incremental.               
               
                  if (!button1) {  
                  cont=0;
                  wait(0.2);
               
                     while(cont<20){ 
                     cont = cont + 1;   
                     kd=kd+1; 
                     
                     if (kd>1000){                     // Ponemos un tope incremental en 1.000
                     kd=1000;
                                 }       
                     lcd.locate(8,1); 
                     lcd.printf("Kd %d",kd); 
                     
                     wait(0.3); 
                     if(button1){ 
                     break; 
                                }              
                     while(cont>=20 and cont<=40){ 
                     cont=cont+1;   
                     kd=kd+10;
                     if (kd>1000){                     // Ponemos un tope incremental en 100
                     kd=1000;
                               }  
                     lcd.locate(8,1); 
                     lcd.printf("Kd %d",kd); 
                                     
                     wait(0.3); 
                     if(button1){ 
                     break; 
                                }
                                
                     while(cont>40){ 
                     cont = cont + 1;   
                     kd=kd+100;
                     if (kd>1000){                     // Ponemos un tope incremental en 1000
                     kd=1000;
                               }  
                     lcd.locate(8,1); 
                     lcd.printf("Kd %d",kd); 
                     
                     wait(0.3); 
                     if(button1){ 
                     break; 
                                }                                
                            }    
                            }
                            }
                            }
                            }
        // Aqui termina el incremental.
                                      }

                                         
                  led2 =1;
                  if (button2.falling()) {  
                  led2 =!led2;                            // Prendo el LED color rojo cada vez que pulso el boton 2 ya que pasa a valer 0 (encendido).       
                  
                  //--sp;                                   // Reduce el valor al pulsar el botón.
                                         } 
                  
                                  
                  // Ahora comienza el decremental.               
               
                  if (!button2) {  
                  cont=0;
                  wait(0.2);
               
                     while(cont<20){ 
                     cont = cont + 1;   
                     kd=kd-1; 
                     
                     if (kd<=0){                         // No permitimos valores negativos, definimos valor mínimo en 0.
                     kd=0;
                              }
                     lcd.locate(11,1);
                     lcd.printf("    ");
                     lcd.locate(8,1);
                     lcd.printf("Kd %d",kd);
                                                                          
                     wait(0.3); 
                     if(button2){ 
                     break; 
                                }              
                      
                     while(cont>=20 and cont<=40){ 
                     cont=cont+1;   
                     kd=kd-10; 
                     if (kd<0){                         // No permitimos valores negativos, definimos valor mínimo en 0.
                     kd=0;
                              }
                     
                     lcd.locate(11,1);
                     lcd.printf("    ");
                     lcd.locate(8,1); 
                     lcd.printf("Kd %d ",kd); 
                     
                                     
                     wait(0.3); 
                     if(button2){ 
                     break; 
                                }
                                
                     while(cont>40){ 
                     cont = cont + 1;   
                     kd=kd-100; 
                     
                     if (kd<0){                         // No permitimos valores negativos, definimos valor mínimo en 0.
                     kd=0;
                              }
                     
                     lcd.locate(11,1);
                     lcd.printf("    ");
                     lcd.locate(8,1); 
                     lcd.printf("Kd %d ",kd); 
                     
                     
                     wait(0.3); 
                     if(button2){ 
                     break; 
                                }   
                           
                            }    
                            }
                            }
                            }
                            
        // Aqui termina el decremental.               
    
                 if (button4.falling()){
                         break;     //sale del bucle si pisan suiche4
                                       }     
            }           
          
//**********************************************************************************
//*******************************************************************************************************          
          
          
          
           lcd.writeCommand(C4);      // Comando para quitar cursor bajo (segun el manual del modulo LCD).
           lcd.cls();                 // Borra la pantalla
           lcd.printf("   GUARDADOS!"); 
           wait(1);
           lcd.cls();
           lcd.printf(" INICIA EL PID");
           wait(1);
           
           // Se imprimen los parches del control.
           
           lcd.cls();
           lcd.printf("Err %d",err);
           lcd.locate(8,0);
           lcd.printf("Med %d",med);
           lcd.locate(0,1);
           lcd.printf("Sp %d",sp);
           lcd.locate(8,1);
           lcd.printf("Co %d",pid);
           wait(1);

        
           // CICLO PRINCIPAL CONTROLADOR PID
           
           while(1) {
           med=Vout*100;             // Se le asigna al puerto Análogo la variable med.
           err = (sp-med);
           
           // Verificamos que la accion integral no sea muy grande.
           
           if (ai < 1000){
           ai =(ki*err)+ai;     //Cálculo de la integral del error;
                         } 
              
           if (ap < 1000){
           ap = kp*err;        //Cálculo de la integral del error;
                         }
                      
           if (ad < 1000){
           ad = kd*(err-err_v);      //Cálculo de la integral del error;
                         } 
           
           pid = (ap+ai+ad);  // Calculo del PID
           
           if(pid<0){                
                pid=0;
                    }
           
           if (pid > 1000){
           pid=1000;
                          } 
          
           //Vout=pid/999;
           
           
           lcd.locate(4,0);
           lcd.printf("%d",err);
           lcd.locate(12,0);
           lcd.printf("%d",med);
           lcd.locate(3,1);
           lcd.printf("%d",sp);
           lcd.locate(12,1);
           lcd.printf("%d",pid);
           wait(0.2);
           
           // se actualizan las variables *******************************************
                  
           // se verifica que pid sea positivo **************************************
           if (pid < 0){
           pid=0;
           } 
           
           
           //  se envia el valor pid a puerto analogico de salida (D/A) **************

            Vout=pid;
            err_v = err;
    
           }          
           }