#include "Setup.h"
#include "mbed.h"
#include "XBee.h"
#include "MODSERIAL.h"
#include "sstream"

Communication::Communication() : pc(USBTX, USBRX, 256,256), XBee(p13, p14,256,256)
{

}

void Communication::DoComConfig(char *swversion)
{

    DigitalOut rst1(p11); //Digital reset for the XBee, 200ns for reset
    DigitalOut Sleep(p12); //0 is awake. 1 is Sleep.


    Sleep = 0; // sleep mode off
    wait_ms(2);
    rst1 = 0; //Set reset pin to 0
    wait_ms(1);//Wait at least one millisecond
    rst1 = 1;//Set reset pin to 1
    wait_ms(1);//Wait another millisecond

    XBee.baud(9600);
    wait_ms(1100);          // no commands within 1sec guard-time
    XBee.printf("+++");     // special command to enter command-mode
    wait_ms(1100);          // no commands within 1sec guard-time

    // Change settings:
    //XBee.printf("ATCH\r");                // Read channel
    XBee.printf("ATCHC\r");                // Set channel 12 (=0xC =default)
    wait_ms(100);
    XBee.printf("ATID1337\r");             // PAN-ID (once chosen to be 1337)
    wait_ms(100);
    //XBee.printf("ATDH13A200\r");          // DH
    XBee.printf("ATDH0\r");                // DH
    wait_ms(100);
    //XBee.printf("ATDL40BFEF31\r");         // DL
    XBee.printf("ATDLFFFF\r");  // DL
    wait_ms(100);
    XBee.printf("ATBD7\r");               // Baudrate nr.7 = 115200
    wait_ms(100);

    // Save and exit:
    XBee.printf("ATWR\r");               // Write settings
    wait_ms(3000);
    XBee.printf("ATCN\r");          // Exit AT mode
    wait_ms(100);
    XBee.baud(115200);        // set mbed-comport
    pc.baud (115200);
 
    pc.printf("Maggie starting\r\n");
    pc.printf(swversion);

    XBee.printf("Maggie starting \r");
    XBee.printf(swversion);
 
    wait_ms(1);

}

IO::IO() : myled1(LED1),myled2(LED2),myled3(LED3),myled4(LED4),LCDRed(p22),LCDGreen(p23),LCDBlue(p24),FB1(p29),FB2(p30),FB3(p26),Speed(p21),CW(p16),CCW(p17),SW1(p18),SW2(p19) 
{
    
}
void IO::DoIOConfig()
{
    //Defining Mbed Pin Functions.
    //Buttons:
    FB1.mode(PullUp); // Black pushbutton, Wire color: Orange & black. (Up)
    FB2.mode(PullUp); // Black pushbutton, Wire color: Orange & black. (Down)
    FB3.mode(PullUp); // Green pushbutton, Wire color: Orange & black. (Select/start)

    //Selector Switch:
    SW1.mode(PullUp);
    SW2.mode(PullUp);

   
}


