#include "Sensors.h"

Magnetic::Magnetic(): i2c(p28, p27)
{

}

////////////////////////////////////TLV493//////////////////////////////////////
void Magnetic::ReadMag(float *output)
{
    char Data[7];
    int i;
    i2c.read( HallAddress,Data,7);

    i = Data[6] | ((Data[3] & 0xF0) <<4);
    i = (i >> 11) == 0 ? i : -1 ^ 0xFFF | i;
    output[3] = (i-320)*1.1;

    i =((Data[4] & 0xF0)>>4) | (Data[0] <<4);
    i = (i >> 11) == 0 ? i : -1 ^ 0xFFF | i;
    output[0]=i * 0.098 * 10.0; //0.098mT/LSB 10Gauss/mT;
    if(abs(output[0])<2) //the sensor has about a 0.2mT | 2Gauss units drift
        output[0] = 0;     //this is a software filter that suppresses most of the noise

    i =(Data[4] & 0x0F) | (Data[1] <<4);
    i = (i >> 11) == 0 ? i : -1 ^ 0xFFF | i;
    output[1]=i * 0.098 * 10.0; //0.098mT/LSB 10Gauss/mT;
    if(abs(output[1])<2) //the sensor has about a 0.2mT | 2Gauss units drift
        output[1] = 0;     //this is a software filter that suppresses most of the noise

    i =(Data[5] & 0x0F) | (Data[2] <<4);
    i = (i >> 11) == 0 ? i : -1 ^ 0xFFF | i;
    output[2]=i * 0.098 * 10.0; //0.098mT/LSB 10Gauss/mT;
//  if(abs(output[2])<2) //the sensor has about a 0.2mT | 2Gauss units drift
//   output[2] = 0;     //this is a software filter that suppresses most of the noise
}

Accelerometer::Accelerometer(): accelerometer(p28, p27)
{

}

void Accelerometer::Init()
{    
    //Setup up of the Accelerometer(ADXL345),refer to the Mbed libary for any changes.
    accelerometer.setPowerControl(0x00); //Go into standby mode to configure the device.
    accelerometer.setDataFormatControl(0x0B); //Full resolution, +/-16g, 4mg/LSB.
    accelerometer.setDataRate(ADXL345_25HZ); //25Hz data rate.
    accelerometer.setPowerControl(0x08); //Measurement mode.
}
void Accelerometer::ReadAcc(float *output)
{
    int readings[3];
    accelerometer.getOutput(readings);
    wait_us(1);
    output[0] = (int16_t) readings[0]; // X-axis
    output[1] = (int16_t) readings[1]; // Y-Axis
    output[2] = (int16_t) readings[2]; // Z-Axis
    output[3] = (atan2 (output[1],output[0]) * 180 / PI) + 180;  // Calculate Angle usoing X and Y
}

LCD::LCD(): i2c_lcd(p9, p10),lcd(&i2c_lcd,LCDaddress,TextLCD::LCD20x4),ioSetup()
{
    
}
void LCD::Readlcd()
{
    
}

//////////////////////////////////LCD_RGB////////////////////////////////////////
void LCD::LCDR()
{
    ioSetup.LCDRed = true;
    ioSetup.LCDGreen = false;
    ioSetup.LCDBlue = false;
}

void LCD::LCDG()
{
    ioSetup.LCDRed = false;
    ioSetup.LCDGreen = true;
    ioSetup.LCDBlue = false;
}

void LCD::LCDB()
{
    ioSetup.LCDRed = false;
    ioSetup.LCDGreen = false;
    ioSetup.LCDBlue = true;
}

void LCD::LCDW()
{
    ioSetup.LCDRed = 1.0;
    ioSetup.LCDGreen = 0.8;
    ioSetup.LCDBlue = 1.0;
}

void LCD::LCDOFF()
{
    ioSetup.LCDRed = false;
    ioSetup.LCDGreen = false;
    ioSetup.LCDBlue = false;
}

void LCD::RefreshLCD(float *AccData,float *MagData)
{
    Battery b;
    LCDW();
    time_t Time = time(0);
    char buffer[32];
    strftime(buffer, 26, "%d-%m-%Y %H:%M:%S", localtime(&Time));

    lcd.locate(0,0);
    lcd.printf(buffer);
    lcd.locate(0,2);
    lcd.printf("%.0f %.1f  %.0f  %.1f    ",AccData[3],b.GetBatteryVoltage(),MagData[3],MagData[2]);
    lcd.locate(0,1);
    lcd.printf("Pos|Vbat|Temp| MagZ ");
    lcd.locate(0,3);
    lcd.printf(" Press start button ");

}

Battery::Battery() :Battery_Status(p20)
{
}
/////////////////////////////////Battery Voltage/////////////////////////////////
float Battery::GetBatteryVoltage()
{

    float R1 = 10000 , R2 = 2440;
    float BatteryR = Battery_Status.read()*3.3;
    float BatteryV = (BatteryR * (R1 + R2)/R2)+0.78;
    return BatteryV;
}