//Jason Mar
#include "mbed.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "uLCD_4DGL.h"
#include "PinDetect.h"
#include <string>
#include <vector>

//initialize all pins
SDFileSystem sd(p5, p6, p7, p8, p9, "sd"); //SD card
uLCD_4DGL uLCD(p28, p27, p29);
PinDetect pb1(p24);
PinDetect pb2(p23);
PinDetect pb3(p22);
PinDetect pb4(p21);

AnalogOut DACout(p18);

wave_player waver(&DACout);
//unused pins
DigitalOut P10(p10);
DigitalOut P11(p11);
DigitalOut P12(p12);
DigitalOut P13(p13);
DigitalOut P14(p14);
DigitalOut P15(p15);
DigitalOut P16(p16);
DigitalOut P17(p17);
DigitalOut P19(p19);
DigitalOut P20(p20);

vector<string> filenames; //filenames are stored in a vector string
int volatile selection = 0;
int volatile totalSongs = 0;
bool play = false;
bool *playptr = &play;

//implement pushbuttons
void pb1_hit_callback (void)
{
   play = !play;
}
void pb2_hit_callback (void)
{
    selection++;
    if(selection >= totalSongs)
        selection = 0;
}
void pb3_hit_callback (void)
{
    selection--;
    if(selection < 0)
        selection = totalSongs - 1;
}
void pb4_hit_callback (void)
{
    int *vol = waver.getVolume();
    *vol = *vol + 1;
    if (*vol >= 16){
        *vol = 0;
    }
}
//reads the file names
void read_file_names(char *dir)
{
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(dir);
  //read all directory and file names in current directory into filename vector
    while((dirp = readdir(dp)) != NULL) {
        filenames.push_back(string(dirp->d_name));
        totalSongs++;
    }
    closedir(dp);
}


int main()
{
    //initialize the buttons
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    pb4.mode(PullUp);
    
    // Delay for initial pullup to take effect
    wait(.01);
    
    // Setup Interrupt callback functions for a pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    pb3.attach_deasserted(&pb3_hit_callback);
    pb4.attach_deasserted(&pb4_hit_callback);
    
    // Start sampling pb inputs using interrupts
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    pb3.setSampleFrequency();
    pb4.setSampleFrequency();
    
    //check for SD card insertion, if no sd card print Insert SD Card
    bool SDinsert = false;
    while(SDinsert == false){
        SDinsert = sd.sd_inserted();
        if(SDinsert == false){
            uLCD.locate(0,1);
            uLCD.printf("Insert SD Card");
        }
        else {
            sd.disk_initialize();
            uLCD.cls();
        }
    }
    FILE *file;
    read_file_names("/sd/myMusic");
    
         
    string song; 
    string dir;
    int c = 0;
    int prevfile = -1;
    while(1) {
        //prints the directory of songs and does not refresh until a pushbutton changes the selection
        if(c == 0 || selection != prevfile){
            prevfile = selection;
            uLCD.cls();
            uLCD.locate(0,0);
            //lists the directory songs in white and the selected song in red
            for(int i=0;i<totalSongs;i++){    
                if(i != selection){
                    int l=filenames[i].size();
                    uLCD.locate(0,i);
                    uLCD.color(WHITE);
                    //substrings the .wav out of the print
                    uLCD.printf("%s",filenames[i].substr(0,l-4));
                }
                else {
                    int l=filenames[selection].size();
                    uLCD.locate(0,selection);
                    uLCD.color(RED);
                    uLCD.printf("%s",filenames[selection].substr(0,l-4));
                }
            }   
        }
        c++;
        
        if(play==true) {
            //concatenates directory with songname
            dir="/sd/myMusic";    
            song = dir + "/" + filenames[selection];
            //reads the wav file
            file = fopen(song.c_str(), "r");
            //clears the screen to print song playiing
            uLCD.cls();
            int l=filenames[selection].size();
            uLCD.locate(0,0);
            uLCD.printf("%s",filenames[selection].substr(0,l-4));
            uLCD.locate(0,1);
            uLCD.printf("%s","Now Playing");
            waver.play(file,playptr);
            play=false;
            fclose(file);
            uLCD.cls();
            //reprint the menu as it was before the song started
            for(int i=0;i<totalSongs;i++){    
                if(i != selection){
                    int l=filenames[i].size();
                    uLCD.locate(0,i);
                    uLCD.color(WHITE);
                    uLCD.printf("%s",filenames[i].substr(0,l-4));
                }
                else {
                    int l=filenames[selection].size();
                    uLCD.locate(0,selection);
                    uLCD.color(RED);
                    uLCD.printf("%s",filenames[selection].substr(0,l-4));
                }
            }
        }
        else
            wait(0.3);
    }
}