#ifndef _JMAPWMOUT_HPP_
#define _JMAPWMOUT_HPP_

#define POSITIVE true
#define NEGATIVE false

#include "mbed.h"

class JMAPwmOut {
    public :
        JMAPwmOut(PinName); 
//        void attach_us(int);
        void start();
        void write(float);
        float read();
        void pulsewidth(float);
        void pulsewidth_ms(int);
        void pulsewidth_us(int);
        void period(float);
        void period_ms(int);
        void period_us(int);
        void stop();
        operator float()  { 
            if ( _width <= 0 ) return 0.0;
            if ( _width > 1 )  return 1.0;
            return _width / _interval;
        }
        JMAPwmOut& operator=(float duty)  {
            _width = _interval * duty;
            if ( duty <= 0 ) _width =  0.0;
            if ( duty > 1 )  _width =  _interval;
            return *this;
        }
    
    private :
        Timeout _timeout;
        Ticker _ticker;
        void TickerInterrupt();
        void end();
        DigitalOut _outPin;
        float _width;
        float _interval;
                
};
#endif