#include "mbed.h"
#include "InterruptIn.h"
#include "JMAPwmOut.hpp"

JMAPwmOut::JMAPwmOut(PinName pin) : _outPin(pin) {  // Constructor definition. Assign _out

    _interval = 0.1; // Default fequency
    _width = 0;
    start(); 
}

float JMAPwmOut::read() {
    return _width / _interval;    
}

void JMAPwmOut::write(float duty) {
    _width = _interval * duty;
    if ( duty <= 0 ) _width =  0.0;
    if ( duty > 1 )  _width =  _interval;
}

void JMAPwmOut::start() {
    _ticker.attach(this,&JMAPwmOut::TickerInterrupt,_interval);
}

void JMAPwmOut::stop() {
    _ticker.detach();
    //wait(width);
}

void JMAPwmOut::period(float period) {
    _interval = period;
    start();
}

void JMAPwmOut::period_ms(int period) {
    JMAPwmOut::period((float)period / 1000);
    start();
}

void JMAPwmOut::period_us(int period) {
    JMAPwmOut::period((float)period / 1000000);
    start();
}

void JMAPwmOut::pulsewidth(float width) {
   _width = width;
   if ( _width < 0) _width = 0.0;
   if ( _width > _interval) _width = _interval;
}

void JMAPwmOut::pulsewidth_ms(int width) {
    JMAPwmOut::pulsewidth((float)width / 1000);
}

void JMAPwmOut::pulsewidth_us(int width) {
    JMAPwmOut::pulsewidth((float)width / 1000000);
}

void JMAPwmOut::TickerInterrupt() {
    _outPin = 0;
    if ( _width <= 0 ) return;
    _timeout.attach(this,&JMAPwmOut::end,_width);   
}

void JMAPwmOut::end() {  
    _outPin = 1;
//    _timeout.detach();
}
;

