#ifndef _MAIN_HPP
#define _MAIN_HPP

/* mes defines  pour mbed-os 
#define HAL_SAI_STATE_TIMEOUT 1
#define HAL_SAI_STATE_ERROR 1 */

#include <string>
#include <stdlib.h>
#include "mbed.h"
#include "prototypes.hpp"
#include "textes.hpp"     // Le tableau des chaines de caractères
// Les objets et autres
#include "DS1820.h"
#include "JMAPwmOut.hpp"
#include "QSPI_DISCO_F746NG.h"
#include "NumericLabel.hpp"
#include "BlinkLabel.hpp"
#include "ButtonGroup.hpp"
#include "SeekbarGroup.hpp"

// Les couleurs
#define BLANC   LCD_COLOR_WHITE
#define NOIR    LCD_COLOR_BLACK
#define CYAN    LCD_COLOR_CYAN
#define ROUGE   LCD_COLOR_RED
#define JAUNE   LCD_COLOR_YELLOW
#define BLEU    LCD_COLOR_BLUE
#define VERT    LCD_COLOR_GREEN
#define MAGENTA LCD_COLOR_MAGENTA
#define ORANGE  LCD_COLOR_ORANGE
#define BRUN    LCD_COLOR_BROWN
#define GRIS    LCD_COLOR_GRAY
#define TRANSPARENT LCD_COLOR_TRANSPARENT

#define BLEU_CLAIR  LCD_COLOR_LIGHTBLUE
#define VERT_CLAIR  LCD_COLOR_LIGHTGREEN
#define ROUGE_CLAIR LCD_COLOR_LIGHTRED
#define CYAN_CLAIR  LCD_COLOR_LIGHTCYAN
#define MAGENTA_CLAIR  LCD_COLOR_LIGHTMAGENTA
#define JAUNE_CLAIR  LCD_COLOR_LIGHTYELLOW
#define GRIS_CLAIR  LCD_COLOR_LIGHTGRAY

#define BLEU_SOMBRE LCD_COLOR_DARKBLUE
#define VERT_SOMBRE LCD_COLOR_DARKGREEN
#define ROUGE_SOMBRE LCD_COLOR_DARKRED
#define CYAN_SOMBRE LCD_COLOR_DARKCYAN
#define MAGENTA_SOMBRE LCD_COLOR_DARKMAGENTA
#define JAUNE_SOMBRE LCD_COLOR_DARKYELLOW
#define GRIS_SOMBRE LCD_COLOR_DARKGRAY

// Les constantes des écrans/boutons
const uint8_t DEMARRER = 0;
const uint8_t ARRETER = 1;
const uint8_t VALIDER = 2;
const uint8_t ANNULER = 3;
const uint8_t REGLER_HORLOGE = 4;
const uint8_t DEPART = 5;
const uint8_t DUREE = 6;
const uint8_t FIN = 7;
const uint8_t ETAT = 8;
const uint8_t DUREE_RESTANTE = 9;
const uint8_t REGLER_CHRONO  = 10;
const uint8_t TAILLE_TAMPON  = 80;
const uint8_t NB_BOUTONS_ACCUEIL = 4;
const string boutonsAccueil[4] = {"Demarrer", "Suspendre", "Arreter", "Regler dessiccateur"};

// QSPI
const uint32_t TAMPON_QSPI              = (uint32_t)TAILLE_TAMPON;
const uint32_t ADRESSE_LECTURE_ECRITURE = (uint32_t)0x0050;
const uint32_t ADRESSE_BASE_QSPI        = (uint32_t)0x90000000;

// Les constantes d'état
const uint8_t ARRETE        = 0;
const uint8_t EN_ATTENTE    = 1;
const uint8_t EN_MARCHE     = 2;
const uint8_t EN_PAUSE      = 3;

// Constantes pour les boutons
const uint16_t posXBoutonHaut       = 280;
const uint16_t posYBoutonHaut       = 25;
const uint16_t largeurBouton        = 180;
const uint16_t hauteurCadreBouton   = 40;
const uint16_t hauteurBouton        = hauteurCadreBouton - 1;
const uint16_t arrondiBouton        = 5;

// Les constantes des écrans
const uint8_t ECRAN_ACCUEIL                 = 0;
const uint8_t ECRAN_MARCHE                  = 1;
const uint8_t ECRAN_ATTENTE                 = 2;
const uint8_t ECRAN_REGLAGE_DESSICCATEUR     = 3;
const uint8_t ECRAN_REGLAGE_HORLOGE         = 4;
//const uint8_t ECRAN_   = ;

#endif // _MAIN_HPP