#ifndef _I2CLCD
#define _I2CLCD
#include <mbed.h>
#include <I2C.h>

class I2CLCD : public I2C
{
  private:
    int MaxChNum;
    int chCount;
    unsigned char LCD_WRITE;
    void init();
  public:
    I2CLCD();
    I2CLCD(int n);
    I2CLCD(PinName sda, PinName scl);
    I2CLCD(PinName sda, PinName scl, int n);
    void write(unsigned char control, unsigned char  dt);
    void write(unsigned char ch);
    void write(char* ch);
    void writeInt(int x);
    void write(int x, int column, char zeroPad);
    void setIcon(int x);
    void home();
    void clear();
    void setCG(char mode, char* cgData);
};
#endif
