#include "I2CLCD.h"
/*
I2C低電圧キャラクタ液晶モジュール
*/

I2CLCD::I2CLCD():I2C(p9,p10)
{
  MaxChNum = 32;
  init();
}

I2CLCD::I2CLCD(int n):I2C(p9,p10)
{
  MaxChNum = n;
  init();
}

I2CLCD::I2CLCD(PinName sda, PinName scl):I2C(sda,scl)
{
  MaxChNum = 32;
  init();
}

I2CLCD::I2CLCD(PinName sda, PinName scl, int n):I2C(sda,scl)
{
  MaxChNum = n;
  init();
}

void I2CLCD::init()
{
  int Wait = 30;
  chCount = 0;
  wait_ms(40);
  LCD_WRITE= 0x7c;
  write(0x0, 0x38);   //data8bit, numberOfLine=2
  wait_us(Wait);
  write(0x0, 0x39);   //data8bit, numberOfLine=2
  wait_us(Wait);
  write(0x0, 0x14);   //internal OSC frequency
  wait_us(Wait);
  if(MaxChNum==32) write(0x0, 0x7f);   // contrast 下4bit
  else write(0x0, 0x78);   // contrast mini
  wait_us(Wait);
  write(0x0, 0x5F);   // power/icon/contrast control
  wait_us(Wait);
  write(0x0, 0x6a);   // follower control
  wait_ms(200);          // 200ms
  write(0x0, 0x0c);   // Display ON
  wait_us(Wait);
  write(0x0, 0x01);   // clear disply
  wait_us(2000);         // 2ms
  write(0x00, 0x06);   // entry mode set
  wait_us(Wait);
}
void I2CLCD::home()
{
    write(0x00,0x02); // return to home
    chCount=0;
    wait_ms(2);
}

void I2CLCD::clear()
{
    write(0x00,0x01); // clear display
    chCount=0;
    wait_ms(2);
}
void I2CLCD::write(unsigned char  ch)
{
  int x;
  int n = MaxChNum/2;
  if(ch==0x0a){
    x= chCount %MaxChNum;
    if(x<n) {
      write(0x00,0xc0);
      chCount=n;
    }
    else {
      write(0x00,0x01); // clear display
      chCount=0;
      wait_ms(2);
    }
  }
  else
  {
    write(0x40,ch);
    x= ++chCount % MaxChNum;
    if( x ==n) write(0x00,0xc0);
  }
}

void I2CLCD::write(char*  ch)
{
  while(*ch){
    write(*ch++);
  }
}

void I2CLCD::write(unsigned char control, unsigned char  dt)
{
  start();
  ((I2C*)this)->write(LCD_WRITE);
  ((I2C*)this)->write(control);
  ((I2C*)this)->write(dt);
  stop();
}
void I2CLCD::write(int x, int column, char zeroPad)
{
  char Buffer[10];
  char num[5];
  int i,j, n=0, signFlag=0;
  if(x<0) {     // マイナスの値の場合
    signFlag=1;
    x *= -1;
  }
  do {
    num[n++] = x%10;
    x /= 10;
  } while(x != 0);
  i = column-n;
  if(i>0) {
    for(i=0; i<10; i++) Buffer[i]=' ';
    if(zeroPad) for(i=0; i<column-n; i++) Buffer[i]='0';
    Buffer[9]=0;
    for(i=column-n, j=n-1; i<column; i++, j--) Buffer[i]=num[j]|'0';
    Buffer[i]=0;
    if(signFlag) Buffer[column-n-1]='-';
  }
  else {
    j=0;
    if(signFlag) Buffer[j++]='-';
    for(i=--n; i>=0; i--) Buffer[j++]=num[i]|'0';
    Buffer[j]=0;
  }
  write(Buffer);
}

void I2CLCD::writeInt(int x)
{
  char num[5];
  int n=0;
  if(x<0) {     // マイナスの値の場合
    write('-');
    x *= -1;
  }
  do {
    num[n++] = x%10 +'0';
    x /= 10;
  } while(x != 0);
  while(--n >=0) write(num[n]);
}

void I2CLCD::setIcon(int x)
{
  write(0x00, 0x39);    // Function set
  write(0x00, 0x40 | 0x0f);   // flower icon
  if(x & 1) write(0x40, 0x10);
  else  write(0x40, 0x00);

  write(0x00, 0x40 | 0x0d);   // Battery icon
  write(0x40, 0);
  if(x & 0x0e) {
    write(0x00, 0x40 | 0x0d);   // Battery icon
    write(0x40, ((x & 0x0e)<<1) | 2);
  }

  write(0x00, 0x40 | 0x0b);   // no sound icon
  if(x & 0x10) write(0x40, 0x10);
  else write(0x40, 0);

  write(0x00, 0x40 | 0x09);   // Key icon
  if(x & 0x20) write(0x40, 0x10);
  else write(0x40, 0);

  write(0x00, 0x40 | 0x07);   // 矢印 icon
  write(0x40, 0);
  if(x & 0xC0) {
    write(0x00, 0x40 | 0x07);   // 矢印 icon
    write(0x40, (x & 0xC0)>>3);
  }

  write(0x00, 0x40 | 0x06);   // enter icon
  if(x & 0x100) write(0x40, 0x10);
  else write(0x40, 0);
  write(0x00, 0x40 | 0x04);   // ring icon
  if(x & 0x200) write(0x40, 0x10);
  else write(0x40, 0);
  write(0x00, 0x40 | 0x02);   // 電話 icon
  if(x & 0x400) write(0x40, 0x10);
  else write(0x40, 0);
  write(0x00, 0x40);    // antena icon
  if(x & 0x800) write(0x40, 0x10);
  else write(0x40, 0);
  write(0x00, 0x38);    // Function set
}

void I2CLCD::setCG(char mode, char* cgData)
{
  unsigned char i, j;
  write(0x00,0x38);     // Function set IS= 0
  write(0x00,0x40);     // CGRAM set address= 0
  if(mode == 0) {    // StringModeで呼ばれた時はデフォールトにセット
    for(i=0; i<8; i++) {
      for(j=0; j<8; j++) {
        if(j < (7-i))   write(0x40,0x00);
        else write(0x40,0x1f);     // 横棒をセット
      }
    }
  }
  else {
    for(i=0; i<64; i++ ) write(0x40, cgData[i]);
  }
}
