#ifndef GP2Y0E03_H
#define GP2Y0E03_H

#include <mbed.h>
#include <I2C.h>

#define DMS_ADDR (0x80)
#define DMS_DIST (0x5E)
#define DMS_RSTADR (0xEE)
#define DMS_RSTCMD (0x06)
#define DMS_128 (0x1)
#define DMS_64 (0x2)
#define DMS_SCALE (0x35)

class GP2Y0E03 {
private:
    I2C* i2cRef;
    char wdata[2];
    char rdata[2];
    int status;

public:
    GP2Y0E03(I2C* ch);
    int writeCommand(char regadr, char dat);
    int readData(char regadr, char* dat);
    int readDistance(int* dist);
};
#endif // GP2Y0E03_H