
#include "GP2Y0E03.h"
//
GP2Y0E03::GP2Y0E03(I2C* ch)
{
    i2cRef=ch;
    wdata[0]=0;
    wdata[1]=0;
    rdata[0]=0;
    rdata[1]=0;
}

int GP2Y0E03::writeCommand(char regadr, char dat)
{
    status =0;
    wdata[0] = regadr;
    wdata[1] = dat;
    status = i2cRef->write(DMS_ADDR, wdata, 2, 0);
    return status;
}

int GP2Y0E03::readData(char regadr, char* dat)
{
    status =0;
    wdata[0] = regadr;
    rdata[0] = 0;
    status = i2cRef->write(DMS_ADDR, wdata, 1, 0);
    if (status !=0) return status;
    status = i2cRef->read(DMS_ADDR, rdata, 1, 0);
    *dat = rdata[0];
    return status;
}

int GP2Y0E03::readDistance(int* dist)
{
    status =0;
    wdata[0] = DMS_DIST;
    rdata[0] = 0;
    rdata[0] = 0;
    status = i2cRef->write(DMS_ADDR, wdata, 1, 0);
    if (status !=0) return (status + 100);
    status = i2cRef->read(DMS_ADDR, rdata, 2, 0);
    *dist = (rdata[0]*16 + rdata[1]) >> 5;
    return status;
}
