/*************************************************************************
 * @file         main.cpp
 *                  
 * @version      1.0
 * @date         Feb 12, 2011
*/

#include "mbed.h"

// Basic includes
#include "jmInterpreter.h"
#include "jmRingBuffer.h"
#include "jmCommands.h"
#include "jmMessages.h"
#include "LPC17xx.h"


LPC_GPIO_TypeDef *jmGPIO[5] ={LPC_GPIO0,LPC_GPIO1,LPC_GPIO2,LPC_GPIO3,LPC_GPIO4};

// CLIG-INCLUDE
#include "jmSwitch.h"


// Initializations
void Inits(){
   InitCommandLineRingBuffer();
   InitMessages();
   cli_version();

   // CLIG-INIT
   SwitchModuleReset();   

}

// EggTimer tickers for modules
void eggTimers(){
   int i;
   // CLIG-TIMER
   // Module jmSwitch
   for(i=0;i<switchQty;i++)if(sSwitch[i].eggTimer>0)sSwitch[i].eggTimer--;

}

int main() {
   unsigned char c;
   Serial pc(USBTX, USBRX);          // communication medium
   pc.baud(115200);                  // 115200 bauds, 8bits, 1 stop, no control flow
   Ticker tick;                      // enable system ticks
   tick.attach_us(&eggTimers,1000);  // enable and select granularity for egg timers
   Inits();                          // initialization

   while(true){
     if( pc.readable()){             // something to read ?
        c= pc.getc();                // read one char   

        if(Echo) printf("%c",c);     // echo it ?

        switch(c){                   // process it

          case  8 : DelChar(pLine);  // remove last one
                    break;
          case 10 : Insert(c,pLine); // end of line
                         Interpret();// process line 
                    break;
          default : Insert(c,pLine); // insert char in command line buffer
        }
     } // if

     // CLIG-SM
     SwitchEdgeDetect();


   }// while
}// main



