/*************************************************************************
 * @file	jmStepper.h
 * @brief	Stepper Control Interface
 *          You can use 4,5,6 and 8 wire steppers.
 *          Each output pin must have two drivers. 
 * 			One driver must be the inverted output pin.
 *          The other driver is the non inverted output pin.
 *          This way the steppers operate in full step, full torque mode.
 *             .
 * @version	1.0
 * @date	Feb 12, 2010
 */

/*
   * Module Command Line Interface 
     Format: command name (arg info)min..max values [optional argument]
      stepper (Stepper number)0..3 (Pin CoilA)0..432 (Pin CoilB)0..432 (Direction)0..1 (Delay)1..255 [(Steps)1..65535] 
      stepperStop (steppers value)1..15

      Example for stepper on pins Port1.31 Port1.30	  DIP20 DIP19
	  stepper 0 131 130 1 1     shortest delays between steps (fastest speed) continuous mode
      stepper 0 131 130 0 1 1   one step in reverse direction 
      stepper 0 131 130 1 10 5  5 steps in foward direction with 10 unit ticks between steps

   * Module Events
      GPPST (stepper id)0..3   
         On Ending steps, Send Message: GPPST id pinA pinB delay status

   *  Module Feedback and Help messages may be enabled/disabled by Command Lines.
		 feedback (enable/disable)0..1
         help (enable/disable)0..1

*/

#ifndef jmStepperdef
  #define jmStepperdef 1

  #define stepperQty 4 // 4 steppers max 

  #include "LPC17xx.h"

  // Module Data Structure
  extern struct StructStepper{
   uint8_t cw;  
   uint8_t active; 
   uint8_t seq;   
   uint8_t delay;            
   uint8_t eggTimer;  
   uint16_t nSteps;
   uint16_t pinA;
   uint16_t pinB;
   uint32_t CoilA_bitValue;
   uint32_t CoilB_bitValue;
   LPC_GPIO_TypeDef *portCoilA;
   LPC_GPIO_TypeDef *portCoilB;
 }sStepper[stepperQty];

#endif

// Module Prototypes
void StepperInit(void);
void StepperSM(void);
void cli_Stepper(void);
void Step(int number, bool CW);
void cli_StepperStop(void);
void cli_GPPST(void);
void rGPPST(unsigned int id);
void cli_StepSpeed(void);

//-------------------------- CLIG PLUGS --------------------
// CLIG-INCLUDE
/*
#include "jmStepper.h"
*/

// CLIG-INIT
/*
   StepperInit();
*/

// CLIG-TIMER
/*
   // Module jmStepper
   for(i=0;i<stepperQty;i++)if(sStepper[i].eggTimer>0)sStepper[i].eggTimer--;
*/

// CLIG-CMD
/*
stepper cli_Stepper();
stepperStop cli_StepperStop();
GPPST cli_GPPST();
stepSpeed cli_StepSpeed();
*/

// CLIG-SM
/*
     StepperSM();
*/
//-------------------------- END CLIG PLUGS --------------------
