/*************************************************************************
 * @file     jmInterpreter.c
 * @brief    Command Line Interpreter
 *                  
 * @date    December 27,2010 
*/

#include "jmInterpreter.h"
#include "jmRingBuffer.h"
#include "jmCommands.h"

/** @brief Interpret a command line.
 * Interpreter uses Command Line Buffer to fecth command name
 * and redirects execution to associated function.
 * @param none
 * @returns none
 */
void Interpret(void){ 
  unsigned int i,k;
  unsigned char Command, found;
  char Word[WordMaxSize];
  Command =0;
  found = 0;
  
  if(NotEmpty(pLine)){
     ExtractWord(pLine,Word);              // Command name extraction 
     for(i=0, k=0;i<sizeof(cmdNames);i++){ // lookup in names array
         if(cmdNames[i]!=Word[k]){         // if different
            while(cmdNames[i]!=0)i++;      // next entry in names array
            Command++;                     // update command index
            k=0;
         }
         else{
           if(Word[k]==0){             
              found=1; 
            } 
           else k++;
         } //else
    
         if(found)break; 
     }  //for
   }
  
  // Command execution
  Action(Command);
}
