/*************************************************************************
 * @file     jmMessages.c
 * @brief    Control System Messages
 *                  
 * @date    December 27,2010 
*/

#include "jmCommands.h"
#include "jmRingBuffer.h"
#include "stdio.h"
#include "jmMessages.h"
#include "stdint.h"
#include "LPC17xx.h"

uint8_t Help;
uint8_t Feedback;
uint8_t Echo;


/** @brief Enable only help messages
 * @param none
 * @returns none
 */
void InitMessages(void){
   Help = 1;
   Echo = 0;
   Feedback = 0;
}
 
/** @brief Send all command names in a project
 * @param none
 * @returns none
 */
void cli_list(void){
   int i,j;
   printf("Commands:\n");
   printf(".......................\n");
   // for each command 
   for(i=0,j=0; i<nbCommands; i++,j++){
      // print name
      while(cmdNames[j]) printf("%c",cmdNames[j++]); 
      printf("\n"); 
   }
   printf("........................\n");
}

/** @brief Send Message Unknown Command from interpreter
 * @param none
 * @returns none
 */
void UnknownCommand(void){
   printf("\n?\n");
}

/** @brief Send Build Version Message
 * @param none
 * @returns none
 */
void cli_version(void){
    printf(jmCLIG);
}

/** @brief Help Command Line Control.
 * Enable/disable help messages
 * When enabled, Typing name only prints Command Format
 * @param none
 * @returns none 
 */
void cli_help(void){
    unsigned int  value;
   if(ExtractUInteger(pLine,&value,0,1)){
      if(value == 1)  printf("Help Enabled ! type command name to print its format\n");
       else printf("Help Disabled !\n");
        
        Help = (uint8_t) value;                // save status
        return;
   } 
   // Error on input, show format
   if(Help)printf("help  (value)0..1\n");
   // Ignore pending command line
   NextCommand(nl,pLine);
}

/** @brief Feedback Command Line Control. 
 * Enable/disable feedback messages
 * When enabled, feedback from user input commands are returned
 * @param none
 * @returns none 
 */
void cli_feedback(void){
    unsigned int  value;
   if(ExtractUInteger(pLine,&value,0,1)){
      if(value == 1)  printf("Feedback Enabled !\n");
       else    printf("Feedback Disabled !\n");
       
        Feedback = (uint8_t)value;        // save status
        return;
   } 

   // Error on input, show format
   if(Help)printf("feedback  (value)0..1\n");
   // Ignore pending command line
   NextCommand(nl,pLine);
}

/** @brief Echo Command Line Control.
 * Enable/disable communication echoes
 * When enabled, user inputs are echoed back
 * @param none
 * @returns none 
 */
void cli_echo(void){
    unsigned int  value;
   if(ExtractUInteger(pLine,&value,0,1)){
      if(value == 1)  printf("Echo Enabled !\n");
       else    printf("Echo Disabled !\n");
        
        Echo = (uint8_t)value;         // save status
       return;
   } 

   // Error on input, show format
   if(Help)printf("echo  (value)0..1\n");
   // Ignore pending command line
   NextCommand(nl,pLine);
}
