/*************************************************************************
 * @file	jmBridge.h
 * @brief	Bridge control on mbed DIP5 to 30.
 *          Up to 4Bridges can be controlled at the same time.
 *             
 * @version	1.0
 * @date	Feb 18, 2011
 */

/*
   * Module Command Line Interface 
     Format: command name (arg info)min..max values [optional argument]
   
     bridge (Bridge ID)0..3 (PinA)0..432 (PinB)0..432 (Direction)0..1 (tOn)0..255 (tOff)0..255 (Cycles)[1..65535]

   * Module Events
         On terminating cycles, send Message: GPPBR id PinA PinB tOn tOff status

   *  Module Feedback and Help messages may be enabled/disabled by Command Lines.
         feedback (enable/disable)0..1
         help (enable/disable)0..1
*/

#ifndef Bridgedef
  #define Bridgedef 1

  #define bridgeQty 4 // max number of Bridge
  
  #include "LPC17xx.h"

  // Module Data Structure
  extern struct StructBridge{
     uint8_t active; 
     uint8_t direction; 
     uint8_t tOff;       
     uint8_t tOn;
     uint8_t state;
     uint16_t pinA;
     uint16_t pinB;
     uint16_t eggTimer;
     uint16_t cycles;
     uint32_t dirBitValue;
     LPC_GPIO_TypeDef * dirPort;
     uint32_t driveBitValue;
     LPC_GPIO_TypeDef * drivePort;
  }sBridge[bridgeQty];

#endif

// Module Prototypes
void cli_Bridge(void);
void BridgeInit(void);
void BridgeSM(void);
void cli_BridgeDC(void);
void cli_GPPBD(void);
void rGPPBD(unsigned int id);

//-------------------------- CLIG PLUGS --------------------
// CLIG-INCLUDE
/*
#include "jmBridge.h"
*/

// CLIG-CMD
/*
bridge cli_Bridge();
GPPBD cli_GPPBD();
bridgeDC cli_BridgeDC();
*/

// CLIG-INIT
/*
   BridgeInit();
*/

// CLIG-TIMER
/*
   // Module jmBridge
   for(i=0;i<bridgeQty;i++)if(sBridge[i].eggTimer>0)sBridge[i].eggTimer--;
*/

// CLIG-SM
/*
     BridgeSM();
*/

