/*************************************************************************
 * @file	jmSwitch.h
 * @brief	Command Line Interface Module for reading switches
 * 			Up to 8 switches can be defined on any digital mbed Pin.
 *          Provide debounce and edge detection
 * @version	1.0
 * @date	Feb 2, 2011

   Command Line Interface 
   Format: command name (arg info)min..max values [optional argument]
      swRead (Switch id)0..3  Return Message: GPPS0 id pin debounce state
      swInit (Switch id)0..7 (Pin number)0..432 (debounce interval)1..255
	          Initialize a Limit Switch Process and return Message: GPPS0 id pin debounce state
	  GPPS0	 Return 8 Message: GPPS0 id pin debounce state

   Module Events
        On closing of switch, Return Message: GPPS0 id pin debounce state
        On Opening of switch, Return Message: GPPS0 id pin debounce state
*/

#ifndef jmSwitchDef
   #define jmSwitchDef 1
   #include "stdint.h"
   #include "LPC17xx.h"

   #define switchQty 8 // max switch qty

    // Module Data Structure
	 extern   struct StructSwitch{ 
	       uint16_t pin;
	       uint8_t debounce;   
		   uint8_t state; 
	       uint8_t eggTimer;  
	       uint32_t bitValue;
	       LPC_GPIO_TypeDef *port;
	    }sSwitch[switchQty]; 
#endif

// Module Prototypes
void SwitchEdgeDetect(void);
void cli_SwitchInit(void);
void cli_SwitchRead(void);
void cli_GPPS0();
void rGPPS0(unsigned int id);
void SwitchModuleReset(void);

//-------------------------- CLIG PLUGS --------------------
// CLIG-INCLUDE
/*
#include "jmSwitch.h"

*/

// CLIG-INIT
/*
   SwitchModuleReset();   
*/

// CLIG-TIMER
/*
   // Module jmSwitch
   for(i=0;i<switchQty;i++)if(sSwitch[i].eggTimer>0)sSwitch[i].eggTimer--;
*/

// CLIG-CMD
/*
swRead cli_SwitchRead();
swInit cli_SwitchInit();
GPPS0 cli_GPPS0();
*/

// CLIG-SM
/*
     SwitchEdgeDetect();
*/

//-------------------------- END CLIG PLUGS --------------------
