/*************************************************************************
 * @file	jmPulse.h
 * @brief	Control pulse duration and repetition on digital mbed pins
 *          Up to 8 pins can be controlled at the same time.
 *          Single pulse or PWM like waveforms can be generated.
 *             
 * @version	1.1
 * @date	Feb 12, 2011
 */

/*
   * Module Command Line Interface 
     Format: command name (arg info)min..max values [optional argument]
     
     pulse (pulse number)0..3 (pin number)0..432 (tOn)0..255 (tOff)0..255 (Cycles)[1..65535]
      Ex: pulse 0 118 5 10 20     Pulse Port1 Bit 18 High for 5 tick units, then Low for 10 ticks and repeat 20 times,
                                 then Return Message: GPPP0 id pin tOn tOff status

      Ex: pulse 0 118 1 0	Set output Port1 Bit 18 High
      Ex: pulse 0 118 0 1	Reset output Port1 Bit 18 Low
	  Ex: pulse 0 118 0 0	Toggle Port1 Bit 18 state

   * Module Events
         On terminating pulse cycles, Return Message: GPPP0 id pin tOn tOff status

   *  Module Feedback and Help messages may be enabled/disabled by Command Lines.
         feedback (enable/disable)0..1
         help (enable/disable)0..1
*/

#ifndef Pulsedef
  #define Pulsedef 1

  #define pulseQty 8 // number of pins for pulse

  #include "LPC17xx.h"

  // Module Data Structure
  extern struct StructPulse{
     uint16_t pin;
	 uint8_t tOff;       
     uint8_t tOn;
	 uint8_t output;
     uint8_t state;
     uint16_t eggTimer;
     uint16_t cycles;
     uint32_t bitValue;
	 LPC_GPIO_TypeDef * port;
  }sPulse[pulseQty];


#endif

// Module Prototypes
void PulseInit(void);
void cli_Pulse(void);
void PulseSM(void);
void SetPulseParam(uint8_t pulseNum, uint16_t pin, uint8_t tOn, uint8_t tOff, uint16_t cycles);
void cli_GPPP0(void);
void rGPPP0(unsigned int id);
void cli_PulseStop(void);

//-------------------------- CLIG PLUGS --------------------
// CLIG-INCLUDE
/*
#include "jmPulse.h"
*/

// CLIG-CMD
/*
pulse cli_Pulse();
pulseInit PulseInit();
pulseStop cli_PulseStop();
GPPP0 cli_GPPP0();
*/

// CLIG-INIT
/*
   PulseInit();
*/

// CLIG-TIMER
/*
   // Module jmPulse
   for(i=0;i<pulseQty;i++)if(sPulse[i].eggTimer>0)sPulse[i].eggTimer--;
*/

// CLIG-SM
/*
     PulseSM();
*/

