/*************************************************************************
 * @file	jmStepperAxis.h
 * @brief	
 *             .
 * @version	1.0
 * @date	Feb 12, 2011
 */

/*
   * Module Command Line Interface 
     Format: command name (arg info)min..max values [optional argument]


   * Module Events

   *  Module Feedback and Help messages may be enabled/disabled by Command Lines.
		 feedback (enable/disable)0..1
         help (enable/disable)0..1

*/

#ifndef jmStepperAxisdef
  #define jmStepperAxisdef 1

  #define stepperAxisQty 4 // 4 steppers max 

  #include "LPC17xx.h"

  // Module Data Structure
  extern struct StructStepperAxis{
   uint8_t active;    
   uint8_t limitCW;  
   uint8_t limitCCW; 
   uint8_t stepperID; 
   uint8_t status;  
 }sStepperAxis[stepperAxisQty];

#endif

// Module Prototypes
void StepperAxisInit(void);
void StepperAxisSM(void);
void cli_StepperAxis(void);
void rGPPSTA(unsigned int id );
void cli_GPPSTA(void);

//-------------------------- CLIG PLUGS --------------------
// CLIG-INCLUDE
/*
#include "jmStepperAxis.h"
*/

// CLIG-INIT
/*
   StepperAxisInit();
*/

// CLIG-NEEDS
/*
jmStepper
jmSwitch
*/

// CLIG-CMD
/*
stepperAxis cli_StepperAxis();
GPPSTA cli_GPPSTA();
*/

// CLIG-SM
/*
     StepperAxisSM();
*/
//-------------------------- END CLIG PLUGS --------------------
