/*************************************************************************
 * @file    jmMotor.h
 * @brief   Control motor drive, direction and repetition on mbed DIP5 to 30.
 *          Up to 4 motors can be controlled at the same time.
 *             
 * @version 1.0
 * @date    Feb 12, 2011
 */

/*
   * Module Command Line Interface 
     Format: command name (arg info)min..max values [optional argument]
   
     motor (Motor ID)0..3 (Direction Pin)0..432 (Drive Pin)0..432 (Rotation cw/ccw)0..1 (tOn)0..255 (tOff)0..255 (Cycles)[1..65535]

   * Module Events
         On terminating cycles, send Message: GPPMT id dirPin drivePinB tOn tOff status

   *  Module Feedback and Help messages may be enabled/disabled by Command Lines.
         feedback (enable/disable)0..1
         help (enable/disable)0..1
*/

#ifndef Motordef
  #define Motordef 1

  #define motorQty 4 // max number of motor
  
  #include "LPC17xx.h"

  // Module Data Structure
  extern struct StructMotor{
     uint8_t active; 
     uint8_t direction; 
     uint8_t tOff;       
     uint8_t tOn;
     uint8_t state;
     uint16_t dirPin;
     uint16_t drivePin;
     uint16_t eggTimer;
     uint16_t cycles;
     uint32_t dirBitValue;
     LPC_GPIO_TypeDef * dirPort;
     uint32_t driveBitValue;
     LPC_GPIO_TypeDef * drivePort;
  }sMotor[motorQty]; 
#endif

// Module Prototypes
void cli_Motor(void);
void MotorInit(void);
void MotorSM(void);
void cli_MotorSpeed(void);
void cli_GPPMT(void);
void rGPPMT(unsigned int id);

//-------------------------- CLIG PLUGS --------------------
// CLIG-INCLUDE
/*
#include "jmMotor.h"
*/

// CLIG-CMD
/*
motor cli_Motor();
GPPMT cli_GPPMT();
motorSpeed cli_MotorSpeed();
*/

// CLIG-INIT
/*
   MotorInit();
*/

// CLIG-TIMER
/*
   // Module jmMotor
   for(i=0;i<motorQty;i++)if(sMotor[i].eggTimer>0)sMotor[i].eggTimer--;
*/

// CLIG-SM
/*
     MotorSM();
*/

