/*************************************************************************
 * @file     jmRingBuffer.h
 * @brief    Command Line Rx Ring Buffer
 *                  
 * @date  Feb12, 2011
*/

#ifndef jmRingBufferDef
 #define jmRingBufferDef 1 
 
 #define nl 10 // new line
 #define WordMaxSize 21
 #define DimRingBuffer  41    
     

 // Ring Buffer data structure
 extern  struct RingBuffer                 
  {  unsigned char  Buffer[DimRingBuffer];      
     unsigned char  head;               
     unsigned char  tail;                 
     unsigned char  qty;   
  }Line, *pLine;
#endif

// Prototypes
bool Full(struct RingBuffer *p);
void Insert(unsigned char c, struct RingBuffer *p);
bool NotEmpty(struct RingBuffer *p);
unsigned char Extract(struct RingBuffer *p);      
void FlushRingBuffer(struct RingBuffer *p); 
void DelChar(struct RingBuffer *p);
void InitCommandLineRingBuffer(void);
void NextCommand(unsigned char c, struct RingBuffer *p);
void ViewRingBuffer(struct RingBuffer *p);
bool ExtractWord(struct RingBuffer *p, char *param);
bool ExtractUInteger(struct RingBuffer *p, unsigned int *result, unsigned int min, unsigned int max);
