    /*********************************************************************
     * main.h
     * by Jason Shen, James Smith and Luis Sanchez
     * Header file for Acoustic Location System DSP
     * Contains #defines, includes, and other constants used for the DSP portion
     * of the UALS.
     *
     * Created on: Apr 25, 2016
     * Author: Jason Shen, James Smith, Luis Sanchez
     */
    
    #ifndef MAIN_H_
    #define MAIN_H_
    
    #include <stdio.h> //fprintf, FILE
    #include <stdlib.h> //
    #include <math.h> //sqrt
    
    #include "float.h"
    #include "mbed.h"
    #include "arm_math.h"
    
    
    #define SAMP_FREQ           (250000)  //Sampling Frequency (Hz)
    #define TRANS_PER_SEC       (10)      //Transmits per second
    #define NUM_SAMPLES         (3000)    //((SAMP_FREQ)/ (TRANS_PER_SEC) / 10) //Total number of samples
    #define DETECT_THRESH       (0.05)    //TODO can be tuned
    #define NUM_TAPS            (64)     //TODO can be tuned
    #define BUOY_DIST           (2)       //Distance from Buoys B and C to A (meters)
    #define DEPTH               (5.0)     //Depth of ROV (meters)
    #define TEMP                (15.0)    //Default water temp (C)
    #define SALINITY            (5.0)     //Default water salinity (parts per thousand)
    #define MOV_AVG_WIND        (20)      //Window for moving average
    
    #define BLOCK_SIZE          (32)
    
    #define UALS_DEBUG          (0)         //Debug flag
    
    /* 
     * FIR filter coeffecients for f = 35kHz with a 500 Hz band pass
     * with 64 taps
     */
    const float coeffsA[NUM_TAPS] = {
            -0.000268,
        -0.000041,
        0.000242,
        0.000398,
        0.000271,
        -0.000134,
        -0.000575,
        -0.000675,
        -0.000217,
        0.000592,
        0.001154,
        0.000900,
        -0.000185,
        -0.001397,
        -0.001744,
        -0.000743,
        0.001059,
        0.002339,
        0.001975,
        0.000001,
        -0.002241,
        -0.003018,
        -0.001556,
        0.001239,
        0.003329,
        0.003058,
        0.000470,
        -0.002605,
        -0.003875,
        -0.002320,
        0.000975,
        0.003594,
        0.003594,
        0.000975,
        -0.002320,
        -0.003875,
        -0.002605,
        0.000470,
        0.003058,
        0.003329,
        0.001239,
        -0.001556,
        -0.003018,
        -0.002241,
        0.000001,
        0.001975,
        0.002339,
        0.001059,
        -0.000743,
        -0.001744,
        -0.001397,
        -0.000185,
        0.000900,
        0.001154,
        0.000592,
        -0.000217,
        -0.000675,
        -0.000575,
        -0.000134,
        0.000271,
        0.000398,
        0.000242,
        -0.000041,
        -0.000268,
    };
    
    
    /* 
     * FIR filter coeffecients for f = 40kHz with a 500 Hz band pass
     * with 64 taps
     */
    const float coeffsB[NUM_TAPS] = {
        0.000308,
        0.000239,
        -0.000066,
        -0.000372,
        -0.000375,
        0.000033,
        0.000558,
        0.000656,
        0.000056,
        -0.000817,
        -0.001079,
        -0.000249,
        0.001081,
        0.001608,
        0.000572,
        -0.001285,
        -0.002188,
        -0.001022,
        0.001371,
        0.002746,
        0.001571,
        -0.001303,
        -0.003209,
        -0.002165,
        0.001069,
        0.003511,
        0.002738,
        -0.000687,
        -0.003605,
        -0.003226,
        0.000157,
        0.003371,
        0.003371,
        0.000157,
        -0.003226,
        -0.003605,
        -0.000687,
        0.002738,
        0.003511,
        0.001069,
        -0.002165,
        -0.003209,
        -0.001303,
        0.001571,
        0.002746,
        0.001371,
        -0.001022,
        -0.002188,
        -0.001285,
        0.000572,
        0.001608,
        0.001081,
        -0.000249,
        -0.001079,
        -0.000817,
        0.000056,
        0.000656,
        0.000558,
        0.000033,
        -0.000375,
        -0.000372,
        -0.000066,
        0.000239,
        0.000308,
    };
    
    /* 
     * FIR filter coeffecients for f = 45kHz with a 500 Hz band pass
     * with 64 taps
     */
    const float coeffsC[NUM_TAPS] = {
        -0.000154,
        -0.000326,
        -0.000130,
        0.000274,
        0.000439,
        0.000067,
        -0.000538,
        -0.000630,
        0.000111,
        0.000961,
        0.000791,
        -0.000488,
        -0.001481,
        -0.000795,
        0.001084,
        0.001982,
        0.000542,
        -0.001843,
        -0.002319,
        0.000010,
        0.002642,
        0.002363,
        -0.000819,
        -0.003320,
        -0.002045,
        0.001769,
        0.003720,
        0.001370,
        -0.002699,
        -0.003728,
        -0.000379,
        0.003570,
        0.003570,
        -0.000379,
        -0.003728,
        -0.002699,
        0.001370,
        0.003720,
        0.001769,
        -0.002045,
        -0.003320,
        -0.000819,
        0.002363,
        0.002642,
        0.000010,
        -0.002319,
        -0.001843,
        0.000542,
        0.001982,
        0.001084,
        -0.000795,
        -0.001481,
        -0.000488,
        0.000791,
        0.000961,
        0.000111,
        -0.000630,
        -0.000538,
        0.000067,
        0.000439,
        0.000274,
        -0.000130,
        -0.000326,
        -0.000154,
    
    };
    float signalABC[NUM_SAMPLES] = {
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.9048270525,
        0.7705132428,
        -0.2486898872,
        -0.9822872507,
        -0.5877852523,
        0.4817536741,
        0.9980267284,
        0.3681245527,
        -0.6845471059,
        -0.9510565163,
        -0.1253332336,
        0.8443279255,
        0.8443279255,
        -0.1253332336,
        -0.9510565163,
        -0.6845471059,
        0.3681245527,
        0.9980267284,
        0.4817536741,
        -0.5877852523,
        -0.9822872507,
        -0.2486898872,
        0.7705132428,
        0.9048270525,
        0.0000000000,
        -0.9048270525,
        -0.7705132428,
        0.2486898872,
        0.9822872507,
        0.5877852523,
        -0.4817536741,
        -0.9980267284,
        -0.3681245527,
        0.6845471059,
        0.9510565163,
        0.1253332336,
        -0.8443279255,
        -0.8443279255,
        0.1253332336,
        0.9510565163,
        0.6845471059,
        -0.3681245527,
        -0.9980267284,
        -0.4817536741,
        0.5877852523,
        0.9822872507,
        0.2486898872,
        -0.7705132428,
        -0.0604991270,
        0.9048270525,
        0.1253332336,
        -0.7705132428,
        -0.9510565163,
        -0.2486898872,
        0.6845471059,
        0.9822872507,
        0.3681245527,
        -0.5877852523,
        -0.9980267284,
        -0.4817536741,
        0.4817536741,
        0.9980267284,
        0.5877852523,
        -0.3681245527,
        -0.9822872507,
        -0.6845471059,
        0.2486898872,
        0.9510565163,
        0.7705132428,
        -0.1253332336,
        -0.9048270525,
        -0.8443279255,
        -0.0000000000,
        0.8443279255,
        0.9048270525,
        0.1253332336,
        -0.7705132428,
        -0.9510565163,
        -0.2486898872,
        0.6845471059,
        0.9822872507,
        0.3681245527,
        -0.5877852523,
        -0.9980267284,
        -0.4817536741,
        0.4817536741,
        0.9980267284,
        0.5877852523,
        -0.3681245527,
        -0.9822872507,
        -0.6845471059,
        0.2486898872,
        0.9510565163,
        0.7705132428,
        -0.1253332336,
        -0.9048270525,
        -0.8443279255,
        -0.0000000000,
        0.8443279255,
        0.9048270525,
        0.1253332336,
        -0.7705132428,
        -0.9510565163,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.7705132428,
        0.9822872507,
        0.4817536741,
        -0.3681245527,
        -0.9510565163,
        -0.8443279255,
        -0.1253332336,
        0.6845471059,
        0.9980267284,
        0.5877852523,
        -0.2486898872,
        -0.9048270525,
        -0.9048270525,
        -0.2486898872,
        0.5877852523,
        0.9980267284,
        0.6845471059,
        -0.1253332336,
        -0.8443279255,
        -0.9510565163,
        -0.3681245527,
        0.4817536741,
        0.9822872507,
        0.7705132428,
        0.0000000000,
        -0.7705132428,
        -0.9822872507,
        -0.4817536741,
        0.3681245527,
        0.9510565163,
        0.8443279255,
        0.1253332336,
        -0.6845471059,
        -0.9980267284,
        -0.5877852523,
        0.2486898872,
        0.9048270525,
        0.9048270525,
        0.2486898872,
        -0.5877852523,
        -0.9980267284,
        -0.6845471059,
        0.1253332336,
        0.8443279255,
        0.9510565163,
        0.3681245527,
        -0.4817536741,
        -0.9822872507,
        -0.7705132428,
        -0.0000000000,
        0.7705132428,
        0.9822872507,
        0.4817536741,
        -0.3681245527,
        -0.9510565163,
        -0.8443279255,
        -0.1253332336,
        0.6845471059,
        0.9980267284,
        0.5877852523,
        -0.2486898872,
        -0.9048270525,
        -0.9048270525,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000,
        0.0000000000
    };
    
    #endif /* MAIN_H_ */ 