#include "stm32f4xx_adc.h"
#include "stm32f4xx_gpio.h"
#include "stm32f4xx_rcc.h"
#include
#include
#include
ADC_CommonInitTypeDef ADC_CommonInitStructure;
volatile unsigned int ConvertedValue = 0; //Converted value readed from ADC
volatile unsigned int sample_data;
TIM_TimeBaseInitTypeDef TIM_TimeBaseStructure;
GPIO_InitTypeDef GPIO_InitStructure;

//void INTTIM_Config(void);

void INTTIM_Config (void)
{
  NVIC_InitTypeDef NVIC_InitStructure;
  /* Enable the TIM2 gloabal Interrupt */
  NVIC_InitStructure.NVIC_IRQChannel = TIM2_IRQn;
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 1;
  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
  NVIC_Init (&NVIC_InitStructure);
  /* TIM2 clock enable */
  RCC_APB1PeriphClockCmd (RCC_APB1Periph_TIM2, ENABLE);
  /* Time base configuration */
  RCC->CFGR |= 0X1400;
  TIM_TimeBaseStructure.TIM_Period = 1000 - 1; // 1 MHz down to 1 KHz (1 ms)
  TIM_TimeBaseStructure.TIM_Prescaler = 42 - 1; // 24 MHz Clock down to 1 MHz (adjust per your clock)
  TIM_TimeBaseStructure.TIM_ClockDivision = 0;
  TIM_TimeBaseStructure.TIM_CounterMode = TIM_CounterMode_Up;
  TIM_TimeBaseInit (TIM2, &TIM_TimeBaseStructure);
  /* TIM IT enable */
  TIM_ITConfig (TIM2, TIM_IT_Update, ENABLE);
  /* TIM2 enable counter */
  TIM_Cmd (TIM2, ENABLE);
}
void init_USART1 (uint32_t baudrate)
{
  GPIO_InitTypeDef GPIO_InitStruct; // this is for the GPIO pins used as TX and RX
  USART_InitTypeDef USART_InitStruct; // this is for the USART1 initilization
  NVIC_InitTypeDef NVIC_InitStructure; // this is used to configure the NVIC (nested vector interrupt controller)
  RCC_APB2PeriphClockCmd (RCC_APB2Periph_USART1, ENABLE);
  RCC->CFGR |= 0xE000;
  /* enable the peripheral clock for the pins used by
  * USART1, PB6 for TX and PB7 for RX
  */
  RCC_AHB1PeriphClockCmd (RCC_AHB1Periph_GPIOB | RCC_AHB1Periph_GPIOA, ENABLE);
  GPIO_InitStruct.GPIO_Pin = GPIO_Pin_6 | GPIO_Pin_7; // Pins 6 (TX) and 7 (RX) are used
  GPIO_InitStruct.GPIO_Mode = GPIO_Mode_AF; // the pins are configured as alternate function so the USART peripheral has access to them
  GPIO_InitStruct.GPIO_Speed = GPIO_Speed_50MHz;     // this defines the IO speed and has nothing to do with the baudrate!
  GPIO_InitStruct.GPIO_OType = GPIO_OType_PP;    // this defines the output type as push pull mode (as opposed to open drain)
  GPIO_InitStruct.GPIO_PuPd = GPIO_PuPd_UP;  // this activates the pullup resistors on the IO pins
  GPIO_Init (GPIOB, &GPIO_InitStruct);
  GPIO_InitStruct.GPIO_Pin = GPIO_Pin_0; // Pins 6 (TX) and 7 (RX) are used
  GPIO_InitStruct.GPIO_Mode = GPIO_Mode_OUT; // the pins are configured as alternate function so the USART peripheral has access to them
  GPIO_InitStruct.GPIO_Speed = GPIO_Speed_50MHz;     // this defines the IO speed and has nothing to do with the baudrate!
  GPIO_InitStruct.GPIO_OType = GPIO_OType_PP;    // this defines the output type as push pull mode (as opposed to open drain)
  GPIO_InitStruct.GPIO_PuPd = GPIO_PuPd_UP;  // this activates the pullup resistors on the IO pins
  GPIO_Init (GPIOA, &GPIO_InitStruct);
  /* The RX and TX pins are now connected to their AF
  * so that the USART1 can take over control of the
  * pins
  */
  GPIO_PinAFConfig (GPIOB, GPIO_PinSource6, GPIO_AF_USART1); //
  GPIO_PinAFConfig (GPIOB, GPIO_PinSource7, GPIO_AF_USART1);
  /* Now the USART_InitStruct is used to define the
  * properties of USART1
  */
  USART_InitStruct.USART_BaudRate = baudrate;    // the baudrate is set to the value we passed into this init function
  USART_InitStruct.USART_WordLength = USART_WordLength_8b;// we want the data frame size to be 8 bits (standard)
  USART_InitStruct.USART_StopBits = USART_StopBits_1;    // we want 1 stop bit (standard)
  USART_InitStruct.USART_Parity = USART_Parity_No;   // we don't want a parity bit (standard)
  USART_InitStruct.USART_HardwareFlowControl = USART_HardwareFlowControl_None; // we don't want flow control (standard)
  USART_InitStruct.USART_Mode = USART_Mode_Tx | USART_Mode_Rx; // we want to enable the transmitter and the receiver
  USART_Init (USART1, &USART_InitStruct);    // again all the properties are passed to the USART_Init function which takes care of all the bit setting
  /* Here the USART1 receive interrupt is enabled
  * and the interrupt controller is configured
  * to jump to the USART1_IRQHandler() function
  * if the USART1 receive interrupt occurs
  */
  USART_ITConfig (USART1, USART_IT_RXNE, ENABLE); // enable the USART1 receive interrupt
  NVIC_InitStructure.NVIC_IRQChannel = USART1_IRQn;  // we want to configure the USART1 interrupts
  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;// this sets the priority group of the USART1 interrupts
  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;     // this sets the subpriority inside the group
  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;    // the USART1 interrupts are globally enabled
  NVIC_Init (&NVIC_InitStructure);   // the properties are passed to the NVIC_Init function which takes care of the low level stuff
// finally this enables the complete USART1 peripheral
  USART_Cmd (USART1, ENABLE);
}

void USART_puts (USART_TypeDef* USARTx, volatile int s)
{
//while(*s){
// wait until data register is empty
  while (! (USARTx->SR & 0x00000040));
  USART_SendData (USARTx, s);
//*s++;
//}
}

void TIM2_IRQHandler (void) //Timer Interupt for sending data
{
  if (TIM_GetITStatus (TIM2, TIM_IT_Update) != RESET) {
    TIM_ClearITPendingBit (TIM2, TIM_IT_Update);
    GPIO_ToggleBits (GPIOA, GPIO_Pin_0);
    sample_data = (uint8_t) (ConvertedValue >> 4); //convert 12 bit data to 8 bits
    USART_puts (USART1, sample_data);
  }
}

void adc_configure()
{
  ADC_InitTypeDef ADC_init_structure; //Structure for adc confguration
  GPIO_InitTypeDef GPIO_initStructre; //Structure for analog input pin
//Clock configuration
  RCC_APB2PeriphClockCmd (RCC_APB2Periph_ADC1, ENABLE); //The ADC1 is connected the APB2 peripheral bus thus we will use its clock source
  RCC_AHB1PeriphClockCmd (RCC_AHB1ENR_GPIOCEN, ENABLE); //Clock for the ADC port!! Do not forget about this one ;)
//Analog pin configuration
  GPIO_initStructre.GPIO_Pin = GPIO_Pin_0;//The channel 10 is connected to PC0
  GPIO_initStructre.GPIO_Mode = GPIO_Mode_AN; //The PC0 pin is configured in analog mode
  GPIO_initStructre.GPIO_PuPd = GPIO_PuPd_NOPULL; //We don't need any pull up or pull down
  GPIO_Init (GPIOC, &GPIO_initStructre); //Affecting the port with the initialization structure configuration
//ADC structure configuration
  ADC_DeInit();
  ADC_init_structure.ADC_DataAlign = ADC_DataAlign_Right;//data converted will be shifted to right
  ADC_init_structure.ADC_Resolution = ADC_Resolution_12b;//Input voltage is converted into a 12bit number giving a maximum value of 4096
  ADC_init_structure.ADC_ContinuousConvMode = ENABLE; //the conversion is continuous, the input data is converted more than once
  ADC_init_structure.ADC_ExternalTrigConv = ADC_ExternalTrigConv_T1_CC1;// conversion is synchronous with TIM1 and CC1 (actually I'm not sure about this one :/)
  ADC_init_structure.ADC_ExternalTrigConvEdge = ADC_ExternalTrigConvEdge_None;//no trigger for conversion
  ADC_init_structure.ADC_NbrOfConversion = 1;//I think this one is clear :p
  ADC_init_structure.ADC_ScanConvMode = DISABLE;//The scan is configured in one channel
  ADC_Init (ADC1, &ADC_init_structure); //Initialize ADC with the previous configuration
//Enable ADC conversion
  ADC_Cmd (ADC1, ENABLE);
//Select the channel to be read from
  ADC_RegularChannelConfig (ADC1, ADC_Channel_10, 1, ADC_SampleTime_144Cycles);
}
int adc_convert()
{
  ADC_SoftwareStartConv (ADC1); //Start the conversion
  while (!ADC_GetFlagStatus (ADC1, ADC_FLAG_EOC)); //Processing the conversion
  return ADC_GetConversionValue (ADC1); //Return the converted data
}

int main (void)
{
  init_USART1 (19200);
  INTTIM_Config();
  adc_configure();
  while (1) {
    ConvertedValue = adc_convert();//Read the ADC converted value
  }
}