/* 06_spi_max7219_led8x8
 *
 * Simple demo to drive a 8x8-as LED matrix by a MAX7219 LED driver IC
 * After initialisation two characters (H and W) are displayed alternatively.
 * The MAX7219 IC is driven by hardware SPI: SPI0 module at PTD1, PTD2, PTD3.
 */

#include "mbed.h"
#include "lib_matrix.h"
#include "ascii_char_h.h"

SPI spi(D11,D12,D13);          // Arduino compatible MOSI, MISO, SCLK
DigitalOut cs(D14);

void MAX7219_init(char noChips)
{
    cs = 1;                         // CS initially High
    spi.format(8,0);                // 8-bit format, mode 0,0
    spi.frequency(1000000);         // SCLK = 1 MHz
    while(noChips)
        MAX7219_config(--noChips);
}
//------------------------------------------------------------------------------
void MAX7219_config(char chip)
{
    MAX7219_write(DECODE_MODE_REG,DISABLE_DECODE,chip);
    MAX7219_write(INTESITY_REG,BRIGHTNESS,chip);
    MAX7219_write(SCAN_LIMIT_REG,SCAN_ALL_DIGITS,chip);
    MAX7219_write(SHUTDOWN_REG,NORMAL_OPERATION,chip);
    MAX7219_write(DISPLAY_TEST_REG,DISABLE_TEST,chip);
}
//------------------------------------------------------------------------------
void MAX7219_write(char regName,char data,char chip)
{
    cs = 0;

    spi.write(regName);
    spi.write(data);
    while(chip--)
        MAX7219_NoOperation();        //Used for daisy chained (Cascaded) arrangements

    cs = 1;
}
//------------------------------------------------------------------------------
void MAX7219_displayText(char* text)
{
    char chip = 0;

    while(*text) {
        char row = (*text++) - 32;//(Text-32)...because the first 32 ASCII character codes are none Printable (control chars)

        for(int col = 0; col < 8; col++) {
            MAX7219_write( col+1, symbol_h[row][col], chip );
        }

        chip++;
    }
}
void MAX7219_displayText(char* text, char indice, char nb_chip)
{
    char chip = 0;
    char * current_pointer;
    current_pointer=text+indice;
    while(chip<nb_chip) {
        char row = (*current_pointer++) - 32;//(Text-32)...because the first 32 ASCII character codes are none Printable (control chars)
        for(int col = 0; col < 8; col++) {
            MAX7219_write( col+1, symbol_h[row][col], chip );
        }
        chip++;
    }
}
void MAX7219_display(unsigned const char led[], char no_chip)
{
    for(int col = 0; col < 8; col++) {
        MAX7219_write( col+1, led[col], no_chip );
    }
}
//-----------Passes the data to the adjacent MAX7219 in the Daisy Chain---------
void MAX7219_NoOperation()
{
    spi.write(NO_OP_REG);
    spi.write(0x00);                //Don't care (Can be any arbitrary value)
}

int main()
{
    MAX7219_init(4);
    while(1) {
        MAX7219_displayText("ABCD");
        wait(2);
        MAX7219_displayText("HELL");
        wait(2);
        MAX7219_display(led_blank,0);
        MAX7219_display(led_heart,1);
        MAX7219_display(led_heart,2);
        MAX7219_display(led_blank,3);
        wait(2);
        for(int i=0;i<7;i++){
            MAX7219_displayText("HELLO WORLD",i,4);
            wait(2);
        }
    }

}