#include "mbed.h"
#include "USBMouse.h"
#include "MMA8451Q.h"

#define LED_ON  0 //outON, pwmON
#define LED_OFF 1 //outOFF,pwmOFF
DigitalOut gLED(LED_GREEN);
DigitalOut rLED(LED_RED);
int copyY=0;
int copyX=0;
int absoluteValY;
int absoluteValX;

#define MMA8451_I2C_ADDRESS (0x1d<<1)
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);

USBMouse mouse;

struct KL46_SENSOR_DATA {

    float   accValX;        //Values of the axis in a variable FLOAT
    float   accValY;
    float   accValZ;
} sensorData;
#define sD sensorData

int main(void)
{
    int sensiblity=100;     //This is sensibility and this will be a parameter to configurate by the users

    while(1) {              //This is a infinite loop to reset the program
    
        wait(1);      //Time what you have to wait to do the next selection
        
        while (1) {



            gLED = LED_OFF;// Red led is off
            rLED = LED_OFF;// Green led is off

            sensorData.accValX = acc.getAccX(); //accX[-1..1]->mouse
            sensorData.accValY = acc.getAccY(); //accY[-1..1]->mouse
            sensorData.accValZ = acc.getAccZ(); //accZ[-1..1]->rLED


            //accXY -> mouse movements from FRDM XY inclination
            mouse.move(sensorData.accValX*30, sensorData.accValY*30);   //This is the magnitude of how much whe want to move the mouse and this also will be a parameter to configurate by the users

            wait(0.1); //wait 100ms


            absoluteValY=sensorData.accValY*sensiblity; //Getting absolute values of X axis
            absoluteValX=sensorData.accValX*sensiblity; //Getting absolute values of Y axis

            if(absoluteValY==copyY&&absoluteValY==copyX) { //This "if" compare the values of the axis and when it is 'true' we are interpreting that the user did the selection
                break; //breking the program

            }
            copyY=absoluteValY; //Copy the value of X axis to compare and detect changes in the value
            copyX=absoluteValX; //Copy the value of Y axis to compare and detect changes in the value

        }




        do {                    //In this part of the program we choose a rank of numbers that we interpret like the user not choose the click

            gLED = LED_OFF;     //Waiting and indicating that the micro is ready to do clic or double clic the code only do a flicker leds
            rLED = LED_ON;
            wait(.1);
            gLED = LED_ON;
            rLED = LED_OFF;
            wait(.1);
            sensorData.accValX = acc.getAccX();
        } while(sensorData.accValX>-.3&&sensorData.accValX<.3);

        sensorData.accValX = acc.getAccX();     //Gettting the value of the X axis



        if(sensorData.accValX>=.3) {            // This part is true when the user move the FRD enought to select only clic

            mouse.click(MOUSE_RIGHT);

            gLED = LED_OFF;
            rLED = LED_ON;

        } else {                                 // The oposite part of the other one is that the user select double clic
            mouse.click(MOUSE_LEFT);
            gLED = LED_ON;
            rLED = LED_OFF;
        }
    }
}
