#include "mbed.h"
#include "LCD_DISCO_F746NG.h"
#include "TS_DISCO_F746NG.h"
#include "Slider.h"

LCD_DISCO_F746NG lcd; // Instanciation de l'écran LCD
TS_DISCO_F746NG ts; // Instanciation de la dalle tactile

DigitalOut led1(LED1); // Instanciation de LED verte

int main()
{  
    led1 = 1;
    uint32_t color;
    uint16_t red,green,blue;
    TS_StateTypeDef TS_State;
    Slider Slider1(10,10,30,200,LCD_COLOR_RED,LCD_COLOR_LIGHTGRAY);
    Slider Slider2(50,10,30,200,LCD_COLOR_GREEN,LCD_COLOR_LIGHTGRAY);
    Slider Slider3(90,10,30,200,LCD_COLOR_BLUE,LCD_COLOR_LIGHTGRAY);
    char Str1[50];
    uint8_t status;
    int Y=136;
    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
    if (status != TS_OK)
    {
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
    }
    else
    {
        lcd.Clear(LCD_COLOR_GREEN);
        lcd.SetBackColor(LCD_COLOR_GREEN);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);
    }
    wait(1);
    lcd.Clear(LCD_COLOR_WHITE);

      
    lcd.SetBackColor(LCD_COLOR_WHITE);
    
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"IUT GEII TOURS", CENTER_MODE);
    
    
    wait(1);
    lcd.Clear(LCD_COLOR_WHITE);
    
    // Draw the 3 sliders
    Slider1.Show();
    Slider2.Show();
    Slider3.Show();
    
    // read the sliders values
    red=Slider1.GetValue();
    green=Slider2.GetValue();
    blue=Slider3.GetValue();
    
    // Calculate and draw the RGB color
    color=0xFF000000;
    color+=red*65536+green*256+blue;
    sprintf(Str1,"Color: 0x%8X",color);
    lcd.SetFont(&Font16);
    lcd.SetTextColor(LCD_COLOR_BLACK);
    lcd.DisplayStringAt(200,250,(uint8_t*) Str1,LEFT_MODE);
    lcd.DrawCircle(300,136,51);
    lcd.SetTextColor(color);
    lcd.FillCircle(300,136,50);
    
    while(1)
    {
        ts.GetState(&TS_State);
        if (TS_State.touchDetected)
        {
          led1 = 1;
          for (int I=0;I<TS_State.touchDetected;I++)
          { 
            // Test touch screen position and move sliders
            Slider1.Move(TS_State.touchX[I],TS_State.touchY[I]);
            Slider2.Move(TS_State.touchX[I],TS_State.touchY[I]);
            Slider3.Move(TS_State.touchX[I],TS_State.touchY[I]);
            
            // read the sliders values
            red=Slider1.GetValue();
            green=Slider2.GetValue();
            blue=Slider3.GetValue();
            
            // Calculate and draw the RGB color
            color=0xFF000000;
            color+=red*65536+green*256+blue;
            sprintf(Str1,"Color: 0x%8X",color);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.SetFont(&Font16);
            lcd.DisplayStringAt(200,250,(uint8_t*) Str1,LEFT_MODE);

            lcd.SetTextColor(color);
            lcd.FillCircle(300,136,50);
          }
          //wait(0.2);
        }
        else
        {
          led1 = 0;
        }

      

    }
}
