#include "Slider.h"
#include <stdio.h>

/* Constructor: define dimensions, positions and colors */
Slider::Slider(uint16_t x, uint16_t y,  uint16_t w, uint16_t h, uint32_t c1, uint32_t c2)
{
    if(x<(maxWidth-w)) xpos=x;
    else xpos=maxWidth-w;
    if(y<(maxHeight-h)) ypos=y;
    else ypos=maxHeight-h;
    if(w<(maxWidth)) width=w;
    else width=maxWidth;
    if(h<(maxHeight)) height=h;
    else height=maxHeight;
    color1=c1;
    color2=c2;
    value=128;
}

/* Draw the slider */
void Slider::Show()
{
    char text[10];
    uint32_t OldTextColor;
    uint32_t OldBackColor;
    sFONT *font;

    // Save previous colors and font
    OldTextColor=BSP_LCD_GetTextColor();
    OldBackColor=BSP_LCD_GetBackColor();
    font = BSP_LCD_GetFont();

    // Draw Slider
    BSP_LCD_SetTextColor(color2);
    BSP_LCD_FillRect(xpos,ypos,width,(height*(255-value))/255);
    BSP_LCD_SetTextColor(color1);
    BSP_LCD_DrawRect(xpos,ypos,width,(height*(255-value))/255);
    BSP_LCD_FillRect(xpos,ypos+(height*(255-value))/255,width,(height*value)/255);

    //Draw text value
    BSP_LCD_SetFont(&Font16);
    BSP_LCD_SetBackColor(color2);
    sprintf(text,"%3d",value);
    BSP_LCD_DisplayStringAt(xpos,ypos+height,(uint8_t*)text,LEFT_MODE);
    
    //Restore colors and fonts
    BSP_LCD_SetTextColor(OldTextColor);
    BSP_LCD_SetBackColor(OldBackColor);
    BSP_LCD_SetFont(font);
}

/* Move the slider if TouchScreen is in area*/
void Slider::Move(uint16_t x, uint16_t y)
{
    if ((x>=xpos) && (x<=xpos+width) && (y>=ypos) && (y<=ypos+height)) { //(y>=ypos+value*height/100-10) && (y<=ypos+value*height/100+10))
        value=255-(y-ypos)*255/height;
        Show();
    }
}

/* read the slider value */
uint16_t Slider::GetValue()
{
    return value;
}

/* write the slider value */
void Slider::SetValue(uint16_t v)
{
    if (v<=255) value=v;
    else value=255;
    Show();
}

/* Destructor */
Slider::~Slider()
{
}
