#include "mbed.h"
#include "wave_player.h"
#include "SDFileSystem.h"
#include "Motor.h"
#include "RGBLed.h"


Motor motorA(p26, p11, p12); // pwm, fwd, rev
Motor motorB(p25, p13, p14); // pwm, fwd, rev

// Setup RGB led using PWM pins and class
RGBLed myRGBled(p22,p23,p24); //red, green, blue PWM pins

// Setup to play wav file from SD Card
AnalogOut DACout(p18);
wave_player waver(&DACout);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card

// Setup for bluetooth
Serial blue(p28,p27);
BusOut myled(LED1,LED2,LED3,LED4);

//also setting any unused analog input pins to digital outputs reduces A/D noise a bit
//see http://mbed.org/users/chris/notebook/Getting-best-ADC-performance/
DigitalOut P16(p16);
DigitalOut P17(p17);
DigitalOut P19(p19);
DigitalOut P20(p20);

void playSound(char * wav)
{
    // need to change code to use threads to play the wav file while avoiding disrupting continuous code flow
    // open wav file
    FILE *wave_file;
    wave_file = fopen(wav,"r");

    // play wav file
    waver.play(wave_file);

    // close wav file
    fclose(wave_file);
}


int main()
{
    float motorSpeed = 0.0;
    char bnum = 0;
    char bhit = 0;
    while(1) 
    {
        motorA.speed(motorSpeed);
        motorB.speed(motorSpeed);
        if (blue.getc() == '!') {
            if (blue.getc() == 'B') { //button data packet
                bnum = blue.getc(); //button number
                bhit = blue.getc(); //1=hit, 0=release
                if (blue.getc() == char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                    myled = bnum - '1'; //current button number will appear on LEDs
                    switch (bnum) {
                        case '1': //number button 1
                            if (bhit=='1') {
                                //add hit code here
                                motorSpeed += 0.2; // speed up
                                myRGBled.write(0.0,1.0,0.0); //green
                            } else {
                                //add release code here
                            }
                            break;
                        case '2': //number button 2
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //add release code here
                                motorSpeed -= 0.2; // slow down
                                myRGBled.write(0.0,0.0,1.0); //blue
                            }
                            break;
                        case '3': //number button 3
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //add release code here
                                motorSpeed = 0.0;
                                myRGBled.write(1.0,0.0,0.0); //red
                            }
                            break;
                        case '4': //number button 4
                            if (bhit=='1') {
                                //add hit code here
                                myRGBled.write(0.5,0.5,0.5); //white

                            } else {
                                //add release code here
                                playSound("/sd/myWavFiles/CarHornHonk.wav");  
                            }
                            break;
                        case '5': //button 5 up arrow
                            if (bhit=='1') {
                                //add hit code here
                                motorSpeed = 0.5; // speed up
                                myRGBled.write(0.0,1.0,1.0); // teal
                            } else {
                                //add release code here
                            }
                            break;
                        case '6': //button 6 down arrow
                            if (bhit=='1') {
                                //add hit code here
                                motorSpeed = -0.5; // speed up
                                myRGBled.write(1.0,0.1,0.0); //orange
                            } else {
                                //add release code here
                            }
                            break;
                        case '7': //button 7 left arrow
                            if (bhit=='1') {
                                //add hit code here
                                myRGBled.write(0.3,0.0,0.6); // purple
                                motorA.speed(-1.0);
                                motorB.speed(1.0);
                                wait(1);
                            } else {
                                //add release code here
                            }
                            break;
                        case '8': //button 8 right arrow
                            if (bhit=='1') {
                                //add hit code here
                                myRGBled.write(1.0,0.0,0.2); // pink
                                motorA.speed(1.0);
                                motorB.speed(-1.0);
                                wait(1);
                            } else {
                                //add release code here
                            }
                            break;
                        default:
                            break;
                    }
                }
            }
        }
    }
}


