
#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "NokiaLCD.h"
#include <string>

EthernetInterface eth;
HTTPClient client;
DigitalOut indicatorLED(LED1);
NokiaLCD lcd(p5, p7, p8, p9, NokiaLCD::LCD6610); // mosi, sclk, cs, rst, type
char *str;
char url[1024];

int main() {
    string text;
    int background = 0x0000FF;
    int squareColor = 0x00FF00;
    int squareLength = 0;
    
    string previousID;
    
    eth.init();
    eth.connect();
    
    str = (char *) malloc(8192);
    
    
    while(1) {
        int ret;
        if(previousID.empty()) {
            ret = client.get("http://api.supertweet.net/1.1/statuses/mentions_timeline.json?count=1", str, 4096);
        } else {
            sprintf(url, "http://api.supertweet.net/1.1/statuses/mentions_timeline.json?since_id=%s\0", previousID.c_str());
            ret = client.get(url, str, 4096);
        }
        if (ret) {
          printf("Error - ret = %d - HTTP return code = %d\n", ret, client.getHTTPResponseCode());
          return 1;
        }
        
        string tweetInfo(str);
        string tweetCommand;
        string tweetSetting;
        size_t foundStart = string::npos;
        if(tweetInfo.compare("[]")) {
            foundStart = tweetInfo.rfind("\"text\":\"@");
        }
        size_t foundEnd;
        while(foundStart != string::npos) {
            foundStart += 24;
            foundEnd = tweetInfo.find(" ",foundStart);
            if(foundEnd != string::npos) {
                tweetCommand = tweetInfo.substr(foundStart, foundEnd - foundStart);
            } else {
                continue;
            }
            foundStart = foundEnd + 1;
            foundEnd = tweetInfo.find("\"",foundStart);
            tweetSetting = tweetInfo.substr(foundStart, foundEnd - foundStart);
            
            printf("%s*%s*\n", tweetCommand.c_str(), tweetSetting.c_str());
            
            if(!tweetCommand.compare("background")) {
                if(!tweetSetting.compare("blue")) {
                    background = 0x0000FF;
                    squareColor = 0x00FF00;
                } else if(!tweetSetting.compare("green")) {
                    background = 0x00FF00;
                    squareColor = 0xFF0000;
                } else if(!tweetSetting.compare("red")) {
                    background = 0xFF0000;
                    squareColor = 0x0000FF;
                } else {
                    text = "Invalid tweet setting";
                }
            } else if(!tweetCommand.compare("write")) {
                text = tweetSetting;
            } else if(!tweetCommand.compare("square")) {
                squareLength = atoi(tweetSetting.c_str());
            } else {
                text = "Invalid tweet command";
            }
            
            foundStart -= 60;
            foundStart = tweetInfo.rfind("\"text\":\"@", foundStart);
            printf("%d*%d*\n", foundStart, string::npos);
        }
        
        lcd.cls();
        lcd.fill(0, 0, 130, 130, background);
        lcd.background(background);
        lcd.locate(0, 7);
        lcd.printf(text.c_str());
        if(squareLength > 0) {
            int i;
            for(int i=65-(squareLength/2); i<65+(squareLength/2);i++) {
                lcd.pixel(i, 65-(squareLength/2), squareColor);
                lcd.pixel(i, 65+(squareLength/2), squareColor);
            }
            for(i=65-(squareLength/2); i<65+(squareLength/2);i++) {
                lcd.pixel(65-(squareLength/2), i, squareColor);
                lcd.pixel(65+(squareLength/2), i, squareColor);
            }
        }
        
        if(tweetInfo.compare("[]")) {
            foundStart = tweetInfo.find("\"id_str\":\"");
            foundStart += 10;
            foundEnd = tweetInfo.find("\"", foundStart);
            previousID = tweetInfo.substr(foundStart, foundEnd - foundStart);
            printf("%s\n", previousID.c_str());
        }
        
        wait(30);
    }
    
}
