#include "tempModule.h"
#include "uLCD_4DGL.h"

class Ball
{
public:    
    // Constructors
    Ball ();
    Ball (float, float, int);
    /* For Part 3: 
     * you need to be able to pass a pin to the 
     * tempModule object from main, so you should
     * add in a PinName argument.
     */
    Ball(PinName);
    Ball(PinName, float, float, int);
    */
    // Set Functions
    void setBaseVx(float); // This sets the lowest velocity of vx (for Thermal pong) or the constant velocity
    void setBaseVy(float); // This sets the lowest velocity of vy (for Thermal pong) or the constant velocity
    void setVxSign(int); 
    void setVySign(int);
    // Get Functions
    int getFutureX();   // get estimate of where the ball will be in the next update()
    int getFutureY();   // get estimate of where the ball will be in the next update()
    // Member Functions
    void reverseXDirection(); // negate the sign for when a ball hits something
    void reverseYDirection(); // negate the sign for when a ball hits something
    void reset(int, int, int, int, uLCD_4DGL *); // takes in a new location and new directions and draws the starting point for the ball
    void update(uLCD_4DGL *); // moves the ball on the screen one vx and vy
    
private:
    // Data members are suggestions, feel free to add/remove
    TempModule *tempSensor; // Pointer -- it's recommended to use "new" operator to create this
    int vxSign;
    int vySign;
    float fx;
    float fy;
    int x;
    int y;
    int radius;
    bool lose;
};
