#include "mbed.h"
#include "ws2812b.h"

#define ARRAY_SIZE(x) (sizeof(x)/sizeof((x)[0]))

int poke_leds (DigitalOut *leds, int num_leds, float delay)
{
    // 000 001 011 010 110 111 101 100
    const uint8_t gray3[] = {0, 1, 3, 2, 6, 7, 5, 4};
    const size_t sz = ARRAY_SIZE(gray3);
    static size_t gray_idx;

    for (int i = 0; i < num_leds; i++) {
        leds[i] = (gray3[gray_idx] >> i) & 1;
    }
    wait(delay);
    
    int ret = gray3[gray_idx++];
    gray_idx %= sz;
    
    return ret;
}

#define RAM_BASE 0x20000000
#define RAM_BB_BASE 0x22000000
#define Var_ResetBit_BB(VarAddr, BitNumber) (*(volatile uint32_t *) (RAM_BB_BASE | ((VarAddr - RAM_BASE) << 5) | ((BitNumber) << 2)) = 0)
#define Var_SetBit_BB(VarAddr, BitNumber) (*(volatile uint32_t *) (RAM_BB_BASE | ((VarAddr - RAM_BASE) << 5) | ((BitNumber) << 2)) = 1)
#define Var_GetBit_BB(VarAddr, BitNumber) (*(volatile uint32_t *) (RAM_BB_BASE | ((VarAddr - RAM_BASE) << 5) | ((BitNumber) << 2)))
#define BITBAND_SRAM(address, bit) ( (__IO uint32_t *) (RAM_BB_BASE + (((uint32_t)address) - RAM_BASE) * 32 + (bit) * 4))

#define varSetBit(var,bit) (Var_SetBit_BB((uint32_t)&var,bit))
#define varResetBit(var,bit) (Var_ResetBit_BB((uint32_t)&var,bit))
#define varGetBit(var,bit) (Var_GetBit_BB((uint32_t)&var,bit))

DigitalOut Orange(PD_12);
extern "C" void toggle_orange (void)
{
    Orange = !Orange;
}

DigitalOut Blue(PD_13);
extern "C" void toggle_blue (void)
{
    Blue = !Blue;
}

Serial pc(USBTX, USBRX);
extern "C" void trace (char* str) 
{
    pc.printf(str);
}

int main() {

    
    DigitalOut leds[] = {LED1, LED2, LED3};
    DigitalOut trig(PD_7);
    
    trig = 1;
    pc.printf("derp.\r\n");
    ws2812b_init();
    trig = 0;
    poke_leds(leds, 3, 0.01);
    ws2812b_set_pixel(0, 1, 64, 128, 196);
    poke_leds(leds, 3, 0.01);
    while(1) {
    trig = 1;
        wait(0.1);
        if(ws2812b.transferComplete) {
            poke_leds(leds, 3, 0.01);
            // Signal that buffer is changed and transfer new data
            ws2812b.startTransfer = 1;
            ws2812b_handle();
        }
        poke_leds(leds, 3, 0.01);
        trig = 0;
    }
}
