#include "mbed.h"
#include "Milkcocoa.h"
#include "BME280.h"
#include "ESP8266Interface.h"

ESP8266Interface wifi(D1,D0);
RawSerial pc(USBTX,USBRX);
BME280 bme(I2C_SDA, I2C_SCL);

/************************* WiFi Access Point *********************************/

#define WLAN_SSID       "..ssid .."
#define WLAN_PASS       ".. password .."

/************************* Your Milkcocoa Setup *********************************/

#define MILKCOCOA_APP_ID      ".. milkcocoa app id .."
#define MILKCOCOA_DATASTORE   "environment"

/************* Milkcocoa Setup (you don't need to change this!) ******************/

#define MILKCOCOA_SERVERPORT  1883

/************ Global State (you don't need to change this!) ******************/
const char MQTT_SERVER[]  = MILKCOCOA_APP_ID ".mlkcca.com";
const char MQTT_CLIENTID[] = __TIME__ MILKCOCOA_APP_ID;

extern void onpush(MQTT::MessageData& md);

int main() {
    
    pc.baud(115200);
    pc.printf("Milkcocoa mbed os ver demo\n\r\n\r\n\r");
    bme.initialize();
    pc.printf("Connecting to %s\n\r",WLAN_SSID);
    
    int ret = wifi.connect(WLAN_SSID, WLAN_PASS, NSAPI_SECURITY_WPA_WPA2);
    if (ret != 0) {
        printf("\r\nConnection error\r\n");
        return -1;
    }
    pc.printf("\n\rWiFi connected\n\r");
    
    Milkcocoa* milkcocoa = new Milkcocoa(&wifi, MQTT_SERVER, MILKCOCOA_SERVERPORT, MILKCOCOA_APP_ID, MQTT_CLIENTID);
    
    milkcocoa->connect();
    
    int count = 0;
    while(1) {
        DataElement elem = DataElement();
        elem.setValue("temperature", bme.getTemperature());
        elem.setValue("humidity", bme.getHumidity());
        elem.setValue("id", "home");
        
        if(count >= 7 ){
            milkcocoa->push(MILKCOCOA_DATASTORE, elem);
            count = 0;
        }
        count++;

        milkcocoa->loop();
        
        Thread::wait(1*1000);
        
    }
}
