#include "mbed.h"
#include "MQTTEthernet.h"
#include "MQTTClient.h"
#include "Milkcocoa.h"
#include "MClient.h"

// The default setting is for the Simple IoT Board(mbed LPC1114FN28)
// Please change to fit the platform
Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);
AnalogIn ain(p15);

/************************* Your Milkcocoa Setup *********************************/
#define MILKCOCOA_APP_ID      "...YOUR_MILKCOCOA_APP_ID..."
#define MILKCOCOA_DATASTORE   "sensor"

/************* Milkcocoa Setup (you don't need to change this!) ******************/

#define MILKCOCOA_SERVERPORT  1883
 
/************ Global State (you don't need to change this!) ******************/

const char MQTT_SERVER[]  = MILKCOCOA_APP_ID ".mlkcca.com";
const char MQTT_CLIENTID[] = __TIME__ MILKCOCOA_APP_ID;

extern void onpush(MQTT::MessageData& md);

int main() {
// void setup() {
    pc.baud(9600);

    MQTTEthernet *ipstack = new MQTTEthernet();
	MClient *client = new MClient(ipstack);
	Milkcocoa *milkcocoa = new Milkcocoa(client, MQTT_SERVER, MILKCOCOA_SERVERPORT, MILKCOCOA_APP_ID, MQTT_CLIENTID);

    pc.printf("Milkcocoa mbed ver demo\n\r\n\r\n\r");
	
	milkcocoa->connect();
	pc.printf("\n\rEther connected\n\r");
	
// }
	while(1) {
// void loop() {
		milkcocoa->loop();
		
		DataElement elem = DataElement();
		
    	float tmp = (ain - 0.1818)/0.00303;
		elem.setValue("tmp", tmp);
		
		milkcocoa->push(MILKCOCOA_DATASTORE, elem);
		wait(7.0);
	}
}
