/* Zumo motor control Library
 *
 * Copyright (c) 2010-2013 jksoft
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "mbed.h"
#include "ZumoControl.h"

ZumoControl::ZumoControl(PinName rc,PinName rp,PinName lc,PinName lp) : _rc(rc),_rp(rp),_lc(lc),_lp(lp)  {
    _pwm.attach_us( this  , &ZumoControl::cycle , MINPULSWIDTH );
    pwm_count = 0;
    pwm_count_max = (int)(1000000.0f/(PERIOD*MINPULSWIDTH));
    
    pwm_set_r = 0;
    pwm_set_l = 0;
    
    value_r = 0;
    value_l = 0;
}

ZumoControl::ZumoControl() : _rc(PTC9),_rp(PTD5),_lc(PTA13),_lp(PTD0)  {
    _pwm.attach_us( this  , &ZumoControl::cycle , MINPULSWIDTH );
    pwm_count = 0;
    pwm_count_max = (int)(1000000.0f/(PERIOD*MINPULSWIDTH));
    
    pwm_set_r = 0;
    pwm_set_l = 0;
    
    value_r = 0;
    value_l = 0;
}

void ZumoControl::cycle(void)
{
    pwm_count++;
    
    if( pwm_count >= pwm_count_max )
    {
        pwm_count = 0;
        value_r = 1;
        value_l = 1;
    }
    
    if(pwm_count >= pwm_set_r )
    {
        value_r = 0;
    }
    if(pwm_count >= pwm_set_l )
    {
        value_l = 0;
    }
    
    _rp = value_r;
    _lp = value_l;
}

void ZumoControl::left_motor (float speed) {
    if( speed > 0 )
    {
        _lc = 0;
    }
    else
    {
        _lc = 1;
    }
    pwm_set_l = (int)((abs(speed) * 10.0)+0.5);
}

void ZumoControl::right_motor (float speed) {
    if( speed > 0 )
    {
        _rc = 1;
    }
    else
    {
        _rc = 0;
    }
    pwm_set_r = (int)((abs(speed) * 10.0)+0.5);
}

void ZumoControl::forward (float speed) {
    _lc = 0;
    _rc = 1;
    pwm_set_l = (int)((speed * 10.0)+0.5);
    pwm_set_r = (int)((speed * 10.0)+0.5);
}

void ZumoControl::backward (float speed) {
    _lc = 1;
    _rc = 0;
    pwm_set_l = (int)((speed * 10.0)+0.5);
    pwm_set_r = (int)((speed * 10.0)+0.5);
}

void ZumoControl::left (float speed) {
    _lc = 1;
    _rc = 1;
    pwm_set_l = (int)((speed * 10.0)+0.5);
    pwm_set_r = (int)((speed * 10.0)+0.5);
}

void ZumoControl::right (float speed) {
    _lc = 0;
    _rc = 0;
    pwm_set_l = (int)((speed * 10.0)+0.5);
    pwm_set_r = (int)((speed * 10.0)+0.5);
}

void ZumoControl::stop (void) {
    pwm_set_l = 0;
    pwm_set_r = 0;
}
