#include "mbed.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

LocalFileSystem local("local");

char LedPtn[256][4];
int LedPtn_num = 0;
int WaitTime = 0;

unsigned char GetFileLine( FILE *stm , char *str ) {
    char count = 0;

    if(fread(&str[count], 1,1,stm) > 0) {
        count++;
        while( (fread(&str[count], 1,1,stm) > 0)
              &&(str[count] != '\n')
             &&(count < 512)) {

            count++;

        }
    }
    str[count] = '\0';

    return(count);
}

int main() {
    FILE *stm;
    char tmp[512];
    int count = 0;
    
    // Get File
    stm = fopen("/local/led.txt","r");
    
    if( stm == NULL ) {
        // File read err
        return(-1);
    }
    
    // Wait time read
    if( GetFileLine( stm , tmp ) == 0 ) {
        // read err
        return(-1);
    }
    if( sscanf( tmp , "%d",&WaitTime ) == 0 ) {
        //read err
        return(-1);
    }
    printf( "Get! Wait time : %d[ms]\r\n", WaitTime );
    
    // LED flash pattern read
    while( (GetFileLine( stm , tmp ) != 0) && (LedPtn_num < 256) ) {
        char *pled = LedPtn[LedPtn_num];
        if( sscanf( tmp , "%d,%d,%d,%d",&pled[0],&pled[1],&pled[2],&pled[3]) == 0)
        {
            break;
        }
        printf( "Get!Led flash pattern : [%d][%d][%d][%d]\r\n", pled[0],pled[1],pled[2],pled[3]);
        LedPtn_num++;
    }
    fclose(stm);
    
    while(1) {
        led1 = LedPtn[count][0];
        led2 = LedPtn[count][1];
        led3 = LedPtn[count][2];
        led4 = LedPtn[count][3];
        wait_ms(WaitTime);
        count++;
        if( count >= LedPtn_num ) {
            count = 0;
        }
    }
}
