/* mbed wallbot mini Library
 *
 * wallbotmini.h
 *
 * Copyright (c) 2010-2013 jksoft
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef WALLBOT_H
#define WALLBOT_H

#include "mbed.h"
#include "TB6612.h"

#define SENSOR_VAL_WIDTH	2000

/** wallbot mini control class
 *
 * Example:
 * @code
 * // Drive the wwallbot forward, turn left, back, turn right, at half speed for half a second

#include "mbed.h"
#include "wallbotmini.h"

wallbotmini wb;
 
int main() {

    wb.sensor_calibrate();

    while(!wb.GetSw())
    {
        wb.set_led(wb.GetLinePosition());
    }
    
    wb.forward(1.0);
    wait (1.0);
    wb.left(1.0);
    wait (1.0);
    wb.backward(1.0);
    wait (1.0);
    wb.right(1.0);
    wait (1.0);
    
    wb.stop();

    while(1);

 }

 * @endcode
 */
class wallbotmini  {

    // Public functions
public:

    /** Create the wallbot object connected to the default pins
     */
    wallbotmini();

    /** Sensor calibrate
     *
     */
    void sensor_calibrate (void);

    /** Directly control the speed and direction of the left motor
     *
     * @param speed A normalised number -1.0 - 1.0 represents the full range.
     */
    void left_motor (float speed);

    /** Directly control the speed and direction of the right motor
     *
     * @param speed A normalised number -1.0 - 1.0 represents the full range.
     */
    void right_motor (float speed);

    /** Drive both motors forward as the same speed
     *
     * @param speed A normalised number 0 - 1.0 represents the full range.
     */
    void forward (float speed);

    /** Drive both motors backward as the same speed
     *
     * @param speed A normalised number 0 - 1.0 represents the full range.
     */
    void backward (float speed);

    /** Drive left motor backwards and right motor forwards at the same speed to turn on the spot
     *
     * @param speed A normalised number 0 - 1.0 represents the full range.
     */
    void left (float speed);

    /** Drive left motor forward and right motor backwards at the same speed to turn on the spot
     * @param speed A normalised number 0 - 1.0 represents the full range.
     */
    void right (float speed);

    /** Stop both motors
     *
     */
    void stop (void);
	
    /** Get floorline position.(int value return.)
     *
     */	
	int GetLinePosition(void);
	
    /** Get switch .(switch OFF:0 or ON:1 return.)
     *
     */	
	int GetSw(void);
	
    /** Set status led .
     * @param led (bit0:LEFT bit1:UP bit2:RIGHT bit3 DOWN)
     */	
	void set_led(int bit);
	
	private :

	TB6612 _right;
	TB6612 _left;
	DigitalIn _sw;
	BusOut _statusled;
	AnalogIn _sensor1;
	AnalogIn _sensor2;
	AnalogIn _sensor3;
	
	int _sensor_def[3];    
};

#endif