/* JKsoft Wallbot LED Library
 *
 * wallbotLED.h
 *
 * Copyright (c) 2010-2016 jksoft
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIALED FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef WALLBOT_LED_H
#define WALLBOT_LED_H

#include "mbed.h"
#include "I2Cdev.h"
#include "TB6612.h"
#include "MPU6050.h"
#include "Adafruit_LEDBackpack.h"
#include "Adafruit_GFX.h"

#define SENSOR_VAL_GAIN_DEFAULT	300
#define SENSOR_VAL_DEFAULT		800

/** wallbot LED control class
 *
 * Example:
 * @code
 * // Drive the wwallbot forward, turn left, back, turn right, at half speed for half a second

#include "mbed.h"
#include "wallbotLED.h"

wallbotLED wb;
 
int main() {

    wb.sensor_calibrate();

    while(!wb.GetSw())
    {
        wb.set_led(wb.GetLinePosition());
    }
    
    wb.forward(1.0);
    wait (1.0);
    wb.left(1.0);
    wait (1.0);
    wb.backward(1.0);
    wait (1.0);
    wb.right(1.0);
    wait (1.0);
    
    wb.stop();

    while(1);

 }

 * @endcode
 */
class wallbotLED  {

    // Public functions
public:

    /** Create the wallbot object connected to the default pins
     */
    wallbotLED();
    
    /** Set Sensor gain.
     *
     * @param Sensor gain.
     */
	void SetFloorSensorGain(int gain);
    /** Sensor calibrate
     *
     */
    void FloorSensorCalibrate (void);

    /** Directly control the speed and direction of the left motor
     *
     * @param speed A normalised number -1.0 - 1.0 represents the full range.
     */
    void driveLeftMotor(float speed);

    /** Directly control the speed and direction of the right motor
     *
     * @param speed A normalised number -1.0 - 1.0 represents the full range.
     * @param speed A normalised number -1.0 - 1.0 represents the full range.
     */
    void driveMotor(float r_speed,float l_speed);

    /** Directly control the speed and direction of the right motor
     *
     * @param speed A normalised number -100 - 100 represents the full range.
     * @param speed A normalised number -100 - 100 represents the full range.
     */
    void driveMotor(int r_speed,int l_speed);
	
    /** Drive both motors
     *
     * @param speed A normalised number -1.0 - 1.0 represents the full range.
     */
    void driveRightMotor(float speed);

    /** Drive both motors forward as the same speed
     *
     * @param speed A normalised number 0 - 1.0 represents the full range.
     */
    void forward(float speed);

    /** Drive both motors backward as the same speed
     *
     * @param speed A normalised number 0 - 1.0 represents the full range.
     */
    void backward(float speed);

    /** Drive left motor backwards and right motor forwards at the same speed to turn on the spot
     *
     * @param speed A normalised number 0 - 1.0 represents the full range.
     */
    void leftTurn(float speed);

    /** Drive left motor forward and right motor backwards at the same speed to turn on the spot
     * @param speed A normalised number 0 - 1.0 represents the full range.
     */
    void rightTurn(float speed);

    /** Stop both motors
     *
     */
    void stop(void);
	
    /** Get floorline position.(int value return.)
     *
     */	
	int GetLinePosition(void);
	
    /** Get switch .(switch OFF:0 or ON:1 return.)
     *
     */	
	int GetSw(void);
	bool GetSw1(void);
	bool GetSw2(void);
	
    /** Set status led .
     * @param led (bit0:LEFT bit2:RIGHT)
     */	
	void SetLed(int bit);

    /** Set led1 .
     * @param led (0:off,1:on)
     */	
	void SetLed1(int bit);

    /** Set led2 .
     * @param led (0:off,1:on)
     */	
	void SetLed2(int bit);
	
	bool GetFloorSensor1();
	bool GetFloorSensor2();
	bool GetFloorSensor3();
	bool GetFloorSensor4();
	
	uint16_t GetFloorSensorRaw1();
	uint16_t GetFloorSensorRaw2();
	uint16_t GetFloorSensorRaw3();
	uint16_t GetFloorSensorRaw4();
	
	void GetAcceleration(float *x,float *y,float *z);
	float GetAccelerationX();
	float GetAccelerationY();
	float GetAccelerationZ();
	
	void GetGyro(float *x,float *y,float *z);
	float GetGyroX();
	float GetGyroY();
	float GetGyroZ();
	
	void SetLedPanel(char data[][16]);
	void SetLedPanel(int x, int y, int flag);
	
private :

	TB6612 _right;
	TB6612 _left;
	MPU6050 _mpu;
	I2C _i2c;
	Adafruit_8x8matrix _matrix1;
	Adafruit_8x8matrix _matrix2;
	BusIn _sw;
	DigitalOut _outlow;
	BusOut _statusled;
	AnalogIn _f_sensor1;
	AnalogIn _f_sensor2;
	AnalogIn _f_sensor3;
	AnalogIn _f_sensor4;
	int _sensor_gain;
	int _sensor_def[4];  
};

#endif