#include "mbed.h"
#include "pictLIB.h"

PICTLIB::PICTLIB(int _dsp_x,int _dsp_y)
{
	dsp_x = _dsp_x;
	dsp_y = _dsp_y;
	dsp_center_x = ((float)dsp_x - 1) / 2.0;
	dsp_center_y = ((float)dsp_y - 1) / 2.0;
	pi = 3.14159265358979323846;
}

void PICTLIB::scroll(char* in_pic, char* out_pic)
{
	for(int y1 = 0 ; y1 < dsp_y ; y1++)
	{
		for(int x1 = 0 ; x1 < dsp_x ; x1++)
		{
			int y2 = y1+1;
			if( y2 >= dsp_y )	y2 -= dsp_y;
			out_pic[(y2 * dsp_y) + x1] = in_pic[(y1 *dsp_y) + x1];
		}
	}
	for(int x1 = 0 ; x1 < dsp_x ; x1++)
	{
		out_pic[(0 * dsp_y) + x1] = in_pic[((dsp_y-1) *dsp_y) + x1];
	}
}

void PICTLIB::rotation(float rad, char* in_pic, char* out_pic)
{
	rad = rad*(pi/180.0);
	
	memset( out_pic , 0 , 16*16 );
	
	float cos_f = cos(-rad);
	float sin_f = sin(-rad);

	for(int y1 = 0 ; y1 < dsp_y ; y1++)
	{
		for(int x1 = 0 ; x1 < dsp_x ; x1++)
		{
			float x2f = ((float)x1-dsp_center_x) * cos_f - ((float)y1-dsp_center_y) * sin_f + dsp_center_x; 
			float y2f = ((float)x1-dsp_center_x) * sin_f + ((float)y1-dsp_center_y) * cos_f + dsp_center_y;
			int x2 = (int)(x2f + 0.5);
			int y2 = (int)(y2f + 0.5);

			if( x2 >= 0  &&  x2 < dsp_x  &&  y2 >= 0  &&  y2 < dsp_y ) {
	            out_pic[(y2 * dsp_y) + x2] = in_pic[(y1 *dsp_y) + x1];
	        }

		}
	}

}