/**
 * Motor Driver TB6612 Control Library
 *
 * -- TB6612 is a device of the TOSHIBA. 
 *
 * Copyright (C) 2012 Junichi Katsu (JKSOFT) 
 */


#include "TB6612.h"

// TB6612 Class Constructor
TB6612::TB6612(PinName pwm, PinName fwd, PinName rev):
        _pwm(pwm), _fwd(fwd), _rev(rev) {

    _fwd = 0;
    _rev = 0;
    _pwm = 0.0;
    _pwm.period(0.001);
    
    bspeed = 0.0;
    timer_flag = false;
}

// Speed Control
//  arg
//   float speed -1.0 - 0.0 - 1.0
void TB6612::speed(float speed) {
    
    if( timer_flag == true )    return;
    
    bspeed = speed;
    
    if( speed > 0.0 )
    {
        _pwm = speed;
        _fwd = 1;
        _rev = 0;
    }
    else if( speed < 0.0 )
    {
        _pwm = -speed;
        _fwd = 0;
        _rev = 1;
    }
    else
    {
        _fwd = 1;
        _rev = 1;
    }
}


// Speed Control with time-out
//  arg
//   float sspeed:-1.0 - 0.0 - 1.0
//   float time  :0.0-
void TB6612::move(float sspeed , float time)
{
    speed(sspeed);
    timer_flag = true;
    timer.attach(this,&TB6612::timeout,time);
}


void TB6612::timeout()
{
    timer_flag = false;
    speed(bspeed);
}

