/**
 * Motor Driver TB6612 Control Library
 *
 * -- TB6612 is a device of the rohm. 
 *
 * Copyright (C) 2012 Junichi Katsu (JKSOFT) 
 */

#ifndef MBED_TB6612_H
#define MBED_TB6612_H

#include "mbed.h"

class TB6612 {
public:
    TB6612(PinName pwm, PinName fwd, PinName rev);
    void speed(float speed);
    void move(float speed , float time);
    void operator= ( float value )
    {
        speed(value);
    }
    
protected:
    PwmOut _pwm;
    DigitalOut _fwd;
    DigitalOut _rev;
    Timeout timer;
    float    bspeed;
    bool     timer_flag;
    void timeout();

};

#endif
