/* wallbot Library
 *
 * wallbot.cpp
 *
 * Copyright (c) 2010-2013 jksoft
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "mbed.h"
#include "wallbot.h"


wallbot::wallbot() :  _right(p22,p14,p13) , _left(p21,p12,p11) , _ain(p15, p16, p17, p18), _left_sw(p29),_right_sw(p30)  {
    PHY_PowerDown();

	_right = 0.0;
    _left = 0.0;
	
	_left_sw.mode(PullUp);
	_right_sw.mode(PullUp);
	
	_floorSensorThreshold = SENSOR_THRESHOLD;
}

void wallbot::left_motor (float speed) {
    _left = speed;
}

void wallbot::right_motor (float speed) {
    _right = speed;
}

void wallbot::forward (float speed) {
    _left = speed;
	_right = speed;
}

void wallbot::backward (float speed) {
    _left = -1.0*speed;
	_right = -1.0*speed;
}

void wallbot::left (float speed) {
    _left = -1.0*speed;
	_right = speed;
}

void wallbot::right (float speed) {
    _left = speed;
	_right = -1.0*speed;
}

void wallbot::stop (void) {
    _right = 0.0;
    _left = 0.0;
}


float wallbot::GetLinePosition(void) {
    float ret = 0.0;
    int bit = 0;
    int value[4];
    
    value[0] = _ain.read_u16(p15);
    value[1] = _ain.read_u16(p16);
    value[2] = _ain.read_u16(p17);
    value[3] = _ain.read_u16(p18);
    
    if( value[0] > _floorSensorThreshold ) bit |= 0x01;
    if( value[1] > _floorSensorThreshold ) bit |= 0x02;
    if( value[2] > _floorSensorThreshold ) bit |= 0x04;
    if( value[3] > _floorSensorThreshold ) bit |= 0x08;
    
    switch(bit)
    {
    case 0x01:    ret = 1.0;      break;
    case 0x03:    ret = 0.66;     break;
    case 0x02:    ret = 0.33;     break;
    case 0x04:    ret = -0.33;    break;
    case 0x0C:    ret = -0.66;    break;
    case 0x08:    ret = -1.0;     break;
    default:    ret = 0.0;        break;
    }
    
    return(ret);
}

void wallbot::GetLinePosition(int *bit) {
    int value[4];
    
    *bit = 0;
    
    value[0] = _ain.read_u16(p15);
    value[1] = _ain.read_u16(p16);
    value[2] = _ain.read_u16(p17);
    value[3] = _ain.read_u16(p18);
    
    if( value[0] > _floorSensorThreshold ) *bit |= 0x01;
    if( value[1] > _floorSensorThreshold ) *bit |= 0x02;
    if( value[2] > _floorSensorThreshold ) *bit |= 0x04;
    if( value[3] > _floorSensorThreshold ) *bit |= 0x08;
}

int wallbot::GetLeftSw(void) {
	return(!_left_sw);
}

int wallbot::GetRightSw(void) {
	return(!_right_sw);
}
