/* mbed wallbot Library
 *
 * wallbot.h
 *
 * Copyright (c) 2010-2013 jksoft
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef WALLBOT_H
#define WALLBOT_H

#include "mbed.h"
#include "HighSpeedAnalogIn.h"
#include "EthernetPowerControl.h"
#include "TB6612.h"

#define SENSOR_NOMAL	0
#define SENSOR_EXT		1
#define SENSOR_THRESHOLD 2500
/** wallbot control class
 *
 * Example:
 * @code
 * // Drive the wwallbot forward, turn left, back, turn right, at half speed for half a second

#include "mbed.h"
#include "wallbot.h"

wallbot wb;
 
int main() {

	wait(0.5);
	
	wb.forward(0.5);
	wait (0.5);
	wb.left(0.5);
	wait (0.5);
	wb.backward(0.5);
	wait (0.5);
	wb.right(0.5);
	wait (0.5);
	
	wb.stop();

 }
 * @endcode
 */
class wallbot  {

    // Public functions
public:

    /** Create the wallbot object connected to the default pins
     */
    wallbot();

    /** Directly control the speed and direction of the left motor
     *
     * @param speed A normalised number -1.0 - 1.0 represents the full range.
     */
    void left_motor (float speed);

    /** Directly control the speed and direction of the right motor
     *
     * @param speed A normalised number -1.0 - 1.0 represents the full range.
     */
    void right_motor (float speed);

    /** Drive both motors forward as the same speed
     *
     * @param speed A normalised number 0 - 1.0 represents the full range.
     */
    void forward (float speed);

    /** Drive both motors backward as the same speed
     *
     * @param speed A normalised number 0 - 1.0 represents the full range.
     */
    void backward (float speed);

    /** Drive left motor backwards and right motor forwards at the same speed to turn on the spot
     *
     * @param speed A normalised number 0 - 1.0 represents the full range.
     */
    void left (float speed);

    /** Drive left motor forward and right motor backwards at the same speed to turn on the spot
     * @param speed A normalised number 0 - 1.0 represents the full range.
     */
    void right (float speed);

    /** Stop both motors
     *
     */
    void stop (void);
	
    /** Get floorline position.(float value return.)
     *
     */	
	float GetLinePosition(void);

    /** Get floorline position.(bit value return.)
     *
     */	
	void GetLinePosition(int *bit);
	
    /** Get left switch .(switch OFF:0 or ON:1 return.)
     *
     */	
	int GetLeftSw(void);

    /** Get GetRightSw switch .(switch OFF:0 or ON:1 return.)
     *
     */	
	int GetRightSw(void);
	
	private :

	TB6612 _right;
	TB6612 _left;

	HighSpeedAnalogIn _ain;
	
	DigitalIn _left_sw;
	DigitalIn _right_sw;

	int _floorSensorThreshold;
    
};

#endif