#include "mbed.h"
#include "LEDStrip.h"
#include "ConfigFile.h"
#include "MQTTEthernet.h"
#include "MQTTClient.h"
#include "Milkcocoa.h"
#include "MClient.h"

#define LED_NUM			60
#define LED_DATA_NUM	3
#define PI 3.14159265359f
#define MAX_COUNT		60
#define STAR_LINE_MAX	60

#if 0
#define DBG(x) x
#else
#define DBG(x)
#endif

/************************* Your Milkcocoa Setup *********************************/
#define MILKCOCOA_APP_ID      "juicej2vchzis"
#define MILKCOCOA_DATASTORE   "halloween"
 
/************* Milkcocoa Setup (you don't need to change this!) ******************/
 
#define MILKCOCOA_SERVERPORT  1883
 
/************ Global State (you don't need to change this!) ******************/
 
const char MQTT_SERVER[]  = MILKCOCOA_APP_ID ".mlkcca.com";
const char MQTT_CLIENTID[] = __TIME__ MILKCOCOA_APP_ID;
 
extern void onpush(MQTT::MessageData& md);

Serial pc(USBTX, USBRX);
LocalFileSystem local("local");
Ticker flipper;
ConfigFile cfg;
DigitalIn SW1(p25);
DigitalIn SW2(p26);
DigitalOut stat_led1(LED1);
DigitalOut stat_led2(LED2);
DigitalOut stat_led3(LED3);
DigitalOut stat_led4(LED4);



void flip();

bool completed = false;
int t_timer = 0;
int like_count = 0;
int max_count = 0;
int demo_count = 0;

const unsigned char _RED[3] = 	{ 0xFF, 0   , 0    };
const unsigned char _GREEN[3] = 	{ 0   , 0xFF, 0    };
const unsigned char _BLUE[3] = 	{ 0   , 0   , 0xFF };
const unsigned char _YELLOW[3] = { 0xFF, 0xFF, 0    };
const unsigned char _PURPLE[3] = { 0xFF, 0   , 0xFF };
const unsigned char _AQUA[3] = 	{ 0   , 0xFF, 0xFF };
const unsigned char _WHITE[3] = 	{ 0xFF, 0xFF, 0xFF };
const unsigned char _GLAY[3] = 	{ 0x80, 0x80, 0x80 };
const unsigned char _DARK_GLAY[3] = { 0x2, 0x2, 0x2 };
const unsigned char _OFF[3] = 	{ 0, 0, 0 };

unsigned char led_data[60][3];

unsigned char base_led_data[60][3];

unsigned char star_line[STAR_LINE_MAX] = { 
	 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
	 10,11,12,13,14,15,16,17,18,19,
	 20,21,22,23,24,25,26,27,28,29,
	 30,31,32,33,34,35,36,37,38,39,
     40,41,42,43,44,45,46,47,48,49,
     50,51,52,53,54,55,56,57,58,59
};

unsigned char color_line[STAR_LINE_MAX][3] =
{
	{ 0xFF, 0x00, 0x00 },{ 0xFF, 0x80, 0x00 },{ 0xFF, 0xFF, 0x00 },{ 0x80, 0xFF, 0x00 },
	{ 0x00, 0xFF, 0x00 },{ 0x00, 0xFF, 0x80 },{ 0x00, 0xFF, 0xFF },{ 0x00, 0x80, 0xFF },
	{ 0x00, 0x00, 0xFF },{ 0x80, 0x00, 0xFF },{ 0xFF, 0x00, 0xFF },{ 0xFF, 0x00, 0x80 },
	{ 0xFF, 0x00, 0x00 },{ 0xFF, 0x80, 0x00 },{ 0xFF, 0xFF, 0x00 },{ 0x80, 0xFF, 0x00 },
	{ 0x00, 0xFF, 0x00 },{ 0x00, 0xFF, 0x80 },{ 0x00, 0xFF, 0xFF },{ 0x00, 0x80, 0xFF },
	{ 0x00, 0x00, 0xFF },{ 0x80, 0x00, 0xFF },{ 0xFF, 0x00, 0xFF },{ 0xFF, 0x00, 0x80 },
	{ 0xFF, 0x00, 0x00 },{ 0xFF, 0x80, 0x00 },{ 0xFF, 0xFF, 0x00 },{ 0x80, 0xFF, 0x00 },
	{ 0x00, 0xFF, 0x00 },{ 0x00, 0xFF, 0x80 },{ 0x00, 0xFF, 0xFF },{ 0x00, 0x80, 0xFF },
	{ 0x00, 0x00, 0xFF },{ 0x80, 0x00, 0xFF },{ 0xFF, 0x00, 0xFF },{ 0xFF, 0x00, 0x80 },
	{ 0xFF, 0x00, 0x00 },{ 0xFF, 0x80, 0x00 },{ 0xFF, 0xFF, 0x00 },{ 0x80, 0xFF, 0x00 },
	{ 0x00, 0xFF, 0x00 },{ 0x00, 0xFF, 0x80 },{ 0x00, 0xFF, 0xFF },{ 0x00, 0x80, 0xFF },
	{ 0x00, 0x00, 0xFF },{ 0x80, 0x00, 0xFF },{ 0xFF, 0x00, 0xFF },{ 0xFF, 0x00, 0x80 },
	{ 0xFF, 0x00, 0x00 },{ 0xFF, 0x80, 0x00 },{ 0xFF, 0xFF, 0x00 },{ 0x80, 0xFF, 0x00 },
	{ 0x00, 0xFF, 0x00 },{ 0x00, 0xFF, 0x80 },{ 0x00, 0xFF, 0xFF },{ 0x00, 0x80, 0xFF },
	{ 0x00, 0x00, 0xFF },{ 0x80, 0x00, 0xFF },{ 0xFF, 0x00, 0xFF },{ 0xFF, 0x00, 0x80 }

};

extern void send_led();

int DownLight(unsigned char *dat,int value)
{
	for(int i=0;i<LED_DATA_NUM;i++)
	{
		if( dat[i] > value )
		{
			dat[i] = dat[i] - value;
		}
	}
	return(0);
}

int near(unsigned char *from_dat,const unsigned char *to_dat,int wide)
{
	int ret_code_l = 1;
	
	for( int i=0;i<LED_DATA_NUM;i++)
	{
		if( from_dat[i] < to_dat[i] )
		{
			if( (from_dat[i]+wide) < to_dat[i] )
			{
				from_dat[i] = from_dat[i] + wide;
				ret_code_l = 0;
			}
			else
			{
				from_dat[i] = to_dat[i];

			}
		}
		else if( from_dat[i] > to_dat[i] )
		{
			if( (from_dat[i]-wide) > to_dat[i])
			{
				from_dat[i] -= wide;
				ret_code_l = 0;
			}
			else
			{
				from_dat[i] = to_dat[i];
			}
		}
	}
	
	return(ret_code_l);
}

int flow_star(int from,int to,const unsigned char *dat,const unsigned char *base_dat,int speed)
{
	int i,j;
	
	if( from < to )
	{
		for(i=from;i<to;i++)
		{
			memcpy( led_data[star_line[i]] , base_dat , 3 );
		}
		
		send_led();
		wait_ms(speed);
		
		for(i=from;i<to;i++)
		{
			for(j=from;j<to;j++)
			{
				if(j==i)
				{
					memcpy( led_data[star_line[j]] , dat , 3 );
				}
				else
				{
					near( led_data[star_line[j]] , base_dat , 5 );
				}
			}
			send_led();
			wait_ms(speed);
			
		}
		
		i = 0;
		j = 1;
		while(i!=(abs(from-to)))
		{
			i = 0;
			for(j=from;j<to;j++)
			{
				i += near( led_data[star_line[j]] , base_dat , 10 );
			}
			send_led();
			wait_ms(speed);
		}
	}
	else
	{
		for(i=from;i>to;i--)
		{
			memcpy( led_data[star_line[i]] , base_dat , 3 );
		}
		
		send_led();
		wait_ms(speed);
		
		for(i=from;i>to;i--)
		{
			for(j=from;j>to;j--)
			{
				if(j==i)
				{
					memcpy( led_data[star_line[j]] , dat , 3 );
				}
				else
				{
					near( led_data[star_line[j]] , base_dat , 5 );
				}
			}
			send_led();
			wait_ms(speed);
		}
		
		i = 0;
		j = 1;
		while(i!=(abs(from-to)))
		{
			i = 0;
			for(j=from;j>to;j--)
			{
				i += near( led_data[star_line[j]] , base_dat , 5 );
			}
			send_led();
			wait_ms(speed);
		}
	}
	
	return(0);
}

int flow_star(int from,int to,const unsigned char *dat,int speed)
{
	int i,j;
	
	if( from < to )
	{
		for(i=from;i<to;i++)
		{
			memcpy( led_data[star_line[i]] , base_led_data[star_line[i]] , 3 );
		}
		
		send_led();
		wait_ms(speed);
		
		for(i=from;i<to;i++)
		{
			for(j=from;j<to;j++)
			{
				if(j==i)
				{
					memcpy( led_data[star_line[j]] , dat , 3 );
				}
				else
				{
					near( led_data[star_line[j]] , base_led_data[star_line[j]] , 5 );
				}
			}
			send_led();
			wait_ms(speed);
			
		}
		
		i = 0;
		j = 1;
		while(i!=(abs(from-to)))
		{
			i = 0;
			for(j=from;j<to;j++)
			{
				i += near( led_data[star_line[j]] , base_led_data[star_line[j]] , 10 );
			}
			send_led();
			wait_ms(speed);
		}
	}
	else
	{
		for(i=from;i>to;i--)
		{
			memcpy( led_data[star_line[i]] , base_led_data[star_line[i]] , 3 );
		}
		
		send_led();
		wait_ms(speed);
		
		for(i=from;i>to;i--)
		{
			for(j=from;j>to;j--)
			{
				if(j==i)
				{
					memcpy( led_data[star_line[j]] , dat , 3 );
				}
				else
				{
					near( led_data[star_line[j]] , base_led_data[star_line[j]] , 5 );
				}
			}
			send_led();
			wait_ms(speed);
		}
		
		i = 0;
		j = 1;
#if 0
		while(i!=(abs(from-to)))
		{
			i = 0;
			for(j=from;j>to;j--)
			{
				i += near( led_data[star_line[j]] , base_led_data[star_line[j]] , 5 );
			}
			send_led();
			wait_ms(speed);
		}
#endif
	}
	
	return(0);
}

void slow_light_all(const unsigned char *base_dat,int speed)
{
	int i,j;
	while(i!=LED_NUM)
	{
		i = 0;
		for(j=0;j<LED_NUM;j++)
		{
			i += near( led_data[j] , base_dat , 5 );
		}
		send_led();
		wait_ms(speed);
	}
}

void back_base(void)
{
	for(int i=0;i<LED_NUM;i++)
	{
		near( led_data[i] , base_led_data[i] , 5 );
		send_led();
	}
}

int glad(int i,unsigned char *dat)
{
	i = i % 0x2FE;
	
	if( i < 0xFF )
	{
		dat[0] = 0xFF * cos(PI/(510.0f/(double)i));
		dat[1] = 0xFF * sin(PI/(510.0f/(double)i));
		dat[2] = 0;
	}
	else if((i >= 0xFF)&&( i < 0x1FE ))
	{
		i -= 0xFF;
		dat[0] = 0;
		dat[1] = 0xFF * cos(PI/(510.0f/(double)i));
		dat[2] = 0xFF * sin(PI/(510.0f/(double)i));
	}
	else if((i >= 0x1FE )&&( i < 0x2FD ))
	{
		i -= 0x1FE;
		dat[0] = 0xFF * sin(PI/(510.0f/(double)i));
		dat[1] = 0;
		dat[2] = 0xFF * cos(PI/(510.0f/(double)i));
	}
	return(0);

}

void idle_cycle(int like) {
	static int old_like_count_i = 0;
	static int cycle = 0;
	static int gorl_flag = 0;
    static int gol_count = 0;
	int point = STAR_LINE_MAX - like; //STAR_LINE_MAX - (int)((float)like / ((float)max_count / (float)STAR_LINE_MAX));
	
	cycle++;
	
	if( old_like_count_i != like ) {

		flipper.detach();
		
		if( like < max_count ) {
			for(int j=0;j<60;j++) {
				memcpy( led_data[j] , base_led_data[j] , 3 );
			}
			printf("COUNT!! %d\r\n",point);
			flow_star(0,point+1,_YELLOW,20);
			flow_star(point,point+1,color_line[point],_WHITE,50);
			flow_star(point,point+1,color_line[point],_WHITE,50);
			flow_star(point,point+1,_WHITE,color_line[point],50);
			memcpy(base_led_data[star_line[point]] , color_line[point] , 3 );
		}
		else if(gorl_flag == 0) {
			gorl_flag = 1;
			flow_star(0,STAR_LINE_MAX,_RED,10);
			flow_star(0,STAR_LINE_MAX,_PURPLE,10);
			flow_star(0,STAR_LINE_MAX,_BLUE,10);
			flow_star(0,STAR_LINE_MAX,_AQUA,10);
			flow_star(0,STAR_LINE_MAX,_RED,10);
			flow_star(0,STAR_LINE_MAX,_GREEN,10);
			flow_star(0,STAR_LINE_MAX,_YELLOW,_OFF,30);
		}
		else {
			flow_star(0,STAR_LINE_MAX,_YELLOW,30);
		}
		
		flipper.attach(&flip, 2.0);
	}
	old_like_count_i = like;
	
	if(gorl_flag == 1) {
		for(int j=0;j<60;j++) {
			glad(gol_count+(j*80),base_led_data[j]);
			memcpy( led_data[j] , base_led_data[j] , 3 );
		}
	}
	else {
		for(int i=0;i<STAR_LINE_MAX;i++) {
			if( i >= point ) {
				memcpy(base_led_data[star_line[i]] , color_line[i] , 3 );
			}
		}
	}
	
	back_base();
	
	gol_count += 30 ;
	if( gol_count >= 0x2FD ) {
		gol_count = 0;
	}

}

void like_change(int like)
{

}

void send_led()
{
	for(int i=0;i<LED_NUM;i++)
	{
		tapeSet(i,led_data[i][0] << 16 | led_data[i][1] << 8 | led_data[i][2]);
	}
	tapeSend();
}


void flip() {
   // like_count += 1;
	led_data[star_line[demo_count]][0] /= 2;
	led_data[star_line[demo_count]][1] /= 2;
	led_data[star_line[demo_count]][2] /= 2;
	
	demo_count += 1;
	
	if( demo_count >= STAR_LINE_MAX )
	{
		demo_count = 0;
	}
}

int main() {
    int old_like_count = 1;
    char tag[64];
    char tmp[5];
    char tmp2[5];
    
    SW1.mode(PullUp);
    SW2.mode(PullUp);
    
    if( SW1 == 0 ) { // DEMO MODE
    	tapeInit(0, LED_NUM+2);

    	while(1) {
			flow_star(0,STAR_LINE_MAX,_RED   ,_OFF,30);
			wait(0.5);
			flow_star(0,STAR_LINE_MAX,_PURPLE,_OFF,30);
			wait(0.5);
			flow_star(0,STAR_LINE_MAX,_BLUE  ,_OFF,30);
			wait(0.5);
			flow_star(0,STAR_LINE_MAX,_AQUA  ,_OFF,30);
			wait(0.5);
			flow_star(0,STAR_LINE_MAX,_GREEN ,_OFF,30);
			wait(0.5);
			flow_star(0,STAR_LINE_MAX,_YELLOW,_OFF,30);
			wait(0.5);
    	}
    }
#if 0
	cfg.read("/local/env.ini");
	
    if (cfg.getValue("TAG", &tag[0], sizeof(tag))) {
        printf("'%s'='%s'\n\r", "TAG", tag);
    }
    else
    {
    	sprintf(tag,"ma9");
    }
    if (cfg.getValue("COUNT", &tmp[0], sizeof(tmp))) {
        printf("'%s'='%s'\n\r", "COUNT", tmp);
        like_count = atoi(tmp);
    }
    else
    {
    	like_count = 0;
    }
    if (cfg.getValue("MAX", &tmp2[0], sizeof(tmp2))) {
        printf("'%s'='%s'\n\r", "MAX", tmp2);
        max_count = atoi(tmp2);
    }
    else
    {
    	max_count = 0;
    }
#endif
	like_count = 0;
	max_count = 60;
    
    printf("ini file read\r\n");
    printf("HashTag:%s\r\n",tag);
    printf("Now Count:%d\r\n",like_count);
    printf("Max Count:%d\r\n",max_count);
    
    stat_led1 = 1;
    	
	for(int i=0;i<LED_NUM;i++) {
		memcpy( led_data[i] , _OFF , 3 );
		memcpy( base_led_data[i] , _DARK_GLAY , 3 );
	}
	
	tapeInit(0, LED_NUM+2);

	send_led();
		
	slow_light_all(_DARK_GLAY , 50);
	

    MQTTEthernet *ipstack = new MQTTEthernet();
	MClient *client = new MClient(ipstack);
	Milkcocoa *milkcocoa = new Milkcocoa(client, MQTT_SERVER, MILKCOCOA_SERVERPORT, MILKCOCOA_APP_ID, MQTT_CLIENTID);

    pc.printf("Milkcocoa mbed ver demo\n\r\n\r\n\r");
    
    
    wait(2);
	
	milkcocoa->connect();
	while(milkcocoa->getConnectStatus()!=1) {
		pc.printf("\n\rEther connected error\n\r");
		pc.printf("\n\rEther re connect\n\r");
		ipstack->reconnect();
		wait(2);
		milkcocoa->connect();
	}
	
    stat_led2 = 1;
	
	int ret = milkcocoa->on(MILKCOCOA_DATASTORE, "push", onpush);
		pc.printf("%d\n\r",ret);
	while(ret != 1){
		wait(1);
		pc.printf("%d\n\r",ret);
		ret = milkcocoa->on(MILKCOCOA_DATASTORE, "push", onpush);
	}
	
    stat_led3 = 1;
	
	while(1)
	{
        milkcocoa->loop();
        
        if(like_count != old_like_count)
        {
			printf("%04d\r\n",like_count);
        	sprintf(&tmp[0],"%d",like_count);
        	//cfg.setValue("COUNT", tmp);
        	if(cfg.write("/local/env.ini"))
        	{
        		printf("SET COUNT\r\n");
        	}
        	else
        	{
        		printf("SET ERR\r\n");
        	}
        	old_like_count = like_count;
        }
 		
		idle_cycle(like_count);
		
	    stat_led4 = !stat_led4;

	}
}

void onpush(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    DataElement de = DataElement((char*)message.payload);
    printf("onpush\n\r");
    like_count++;
}


