/*
Touchpad driver.

CPV, 3/9/2009
*/

#ifndef __TOUCHPAD_H__
#define __TOUCHPAD_H__


#include "mbed.h"
#include "filters.h"


class TouchpadChannel
{
public:
	void initialise(int min, int quantise_step);
	void tick(int v) { m_filter.tick(v); }
	int quantise(void);
	int operator()(void) { return m_quantised; }
	int get_raw(void) { return m_filter(); }

protected:
	FilterBoxI m_filter;
	int m_min;
	int m_quantise_step;
	int m_quantised;
};


class Touchpad
{
public:
	Touchpad(PinName x0, PinName x1, PinName y0, PinName y1);

	void tick(void);

	int get_raw_x(void) { return m_ch_x.get_raw(); }
	int get_raw_y(void) { return m_ch_y.get_raw(); }

	int hotspot(void) { return (m_ch_x.quantise()>=0 && m_ch_y.quantise()>=0); }
	int get_hotspot_x(void) { return m_ch_x(); }
	int get_hotspot_y(void) { return m_ch_y(); }

protected:
	TouchpadChannel m_ch_x;
	TouchpadChannel m_ch_y;

	PinName m_x0;
	PinName m_x1;
	PinName m_y0;
	PinName m_y1;

	int read(PinName drive_hi, PinName drive_lo, PinName read_hi, PinName read_lo);
	int read_x(void) { return read(m_x1,m_x0,m_y1,m_y0); }
	int read_y(void) { return read(m_y1,m_y0,m_x1,m_x0); }
};


#endif // __TOUCHPAD_H__