/*
mbed touchpad & accelerometer experiments.

CPV, 14/09/2009
*/


#ifndef __FILTERS_H__
#define __FILTERS_H__

#define FILTER_MAX_SIZE  16

class FilterBoxF
{
public:
    FilterBoxF(void) { initialise(FILTER_MAX_SIZE); }
    void initialise(unsigned int size);
    float tick(float in);
    float get() { return m_out; }
    float operator()(void) { return m_out; }

protected:
    float m_history[FILTER_MAX_SIZE];
    unsigned int m_size;
    unsigned int m_index;
    float m_out;
};


class FilterBoxI
{
public:
    FilterBoxI(void) { initialise(FILTER_MAX_SIZE); }
    void initialise(unsigned int size);
    int tick(int in);
    int operator()(void) { return m_out; }

protected:
    int m_history[FILTER_MAX_SIZE];
    unsigned int m_size;
    unsigned int m_index;
    int m_out;
};


class FilterIirI
{
public:
    FilterIirI(void) { initialise(); }
    void initialise(int tau=1, int limit=0xffff);
    int tick(int in);
    int operator()(void) { return m_out; }

protected:
    int m_out;
    int m_remainder;
    int m_limit;
    int m_tau;
};
#endif