/*
Touchpad driver.

CPV, 3/9/2009
*/

#include "touch.h"


void TouchpadChannel::initialise(int min, int quantise_step)
{
	m_min = min;
	m_quantise_step = quantise_step;
	m_filter.initialise(8);
	m_quantised = -1;
}


int TouchpadChannel::quantise(void)
{
	m_quantised = -1;
	int raw = m_filter();
	
	if (raw>m_min)
	{
		m_quantised = 0;
		
		while(raw>m_quantise_step)
		{
			raw -= m_quantise_step;
			m_quantised += 1;
		}
	}
	return m_quantised;
}


//===============================================


Touchpad::Touchpad(PinName x0, PinName x1, PinName y0, PinName y1)
{
	m_x0 = x0;
	m_x1 = x1;
	m_y0 = y0;
	m_y1 = y1;
	m_ch_x.initialise(0.1*0xffff,0.16*0xffff);
	m_ch_y.initialise(0.1*0xffff,0.22*0xffff);
}


int Touchpad::read(PinName drive_hi, PinName drive_lo, PinName read_hi, PinName read_lo)
{
	DigitalOut out1(drive_hi);
	DigitalOut out0(drive_lo);
	AnalogIn in1(read_hi);
	AnalogIn in0(read_lo);
	out0 = 0;
	out1 = 1;
	
	return in1.read_u16();
}


void Touchpad::tick(void)
{
	m_ch_x.tick(read_x());
	m_ch_y.tick(read_y());
}